/* $Id: log.h,v 1.5 2001/06/24 19:43:01 mis Exp $ */
#ifndef POLDEK_LOG_H
#define POLDEK_LOG_H

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#include <stdarg.h>

#define	LOGERR	        (1 << 1)	/* error conditions */
#define	LOGWARN	        (1 << 2)	/* warning conditions */
#define	LOGINFO	        (1 << 4)	/* informational */
#define	LOGDEBUG	(1 << 5)	/* debug-level messages */

extern int verbose;

int log_openlog(const char *pathname, unsigned mask, char *prefix);
int log_sopenlog(FILE *stream, unsigned mask, char *prefix);
void log_closelog(void);

FILE *log_stream(void);

void log_msg(const char *fmt, ...);
void log_msg_i(int indent, const char *fmt, ...);

void msg(int verbose_level, const char *fmt, ...);
#define msg(verbose_level, fmt, args...)   \
  do {                                     \
    if ((verbose_level) <= verbose)        \
      log_msg(fmt, ## args);               \
  } while(0)

#define msg_i(verbose_level, indent, fmt, args...)   \
  do {                                               \
    if ((verbose_level) <= verbose)                  \
      log_msg_i(indent, fmt, ## args);               \
  } while(0)

#define msg_l(verbose_level, fmt, args...)           \
  do {                                               \
    if ((verbose_level) >= verbose && verbose > 0)   \
      log_msg(fmt, ## args);                         \
  } while(0)

void do_vlog(int pri, int indent, const char *fmt, va_list args);

/* wrapper around vlog_do */
void vlog(int pri, int indent, const char *fmt, va_list args);
void log(int pri, const char *fmt, ...);

#define log_debug(fmt, args...) \
  log(LOG_DEBUG, "%s: " fmt, __FUNCTION__ , ## args)

void log_set_vprintf(int (*vprintffn)(const char *, va_list));

void log_set_vlogfn(void (*vlogfn)(int, int, const char*, va_list));

#if ENABLE_TRACE
# define DBGF(fmt, args...)  fprintf(stderr, "%-18s: " fmt, __FUNCTION__ , ## args)
# define DBG(fmt, args...)   fprintf(stderr, fmt, ## args)
#else 
# define DBGF(fmt, args...)  ((void) 0)
# define DBG(fmt, args...)    ((void) 0)
#endif

#define DBGMSG_F DBGF
#define DBGMSG   DBG

#endif /* POLDEK_LOG_H */
