/*
 * dml - Dialog Markup Language
 *
 * $Id: util.c,v 1.1 2001/01/16 16:12:03 malekith Exp $
 * Author: Michal Moskal <malekith@pld.org.pl>
 * include COPYING-GNU
 */

#include "pi.h"
#include <string.h>

void pi_center(struct pi_window *w)
{
	w->pos.x = (pi_screen_width - w->pos.w) / 2;
	w->pos.y = (pi_screen_height - w->pos.h) / 2;
}

void pi_draw(struct pi_object *p)
{
	p->f->draw(p);
}

void pi_locate(struct pi_object *self, int *xx, int *yy)
{
	int x, y;
	struct pi_object *p;

	x = y = 0;

	for (p = self; p; p = p->parent) {
		x += p->pos.x;
		y += p->pos.y;
	}

	pi_goto(x, y);
	if (xx)
		*xx = x;
	if (yy)
		*yy = y;
}

void pi_setstr(char **p, const char *s)
{
	if (*p == s)
		return;

	xfree(*p);
	*p = xmalloc(strlen(s) + 1);
	strcpy(*p, s);
}

int pi_is_active(struct pi_object *self)
{
	return self->parent == 0 ||
	       (pi_is_active(self->parent) && self->parent->active == self);
}

void pi_setpos(struct pi_object *p, int x, int y, int w, int h)
{
	p->pos.w = w;
	p->pos.h = h;
	p->pos.x = x;
	p->pos.y = y;
}

void pi_scrollbar(int i, int top, int h, int nlines, int color, int color_hl)
{
	if ((i - top < top * h / nlines) ||
	    (i - top > (top + h) * h / nlines)) {
		pi_color(color);
		pi_putch('.');
	} else {
		pi_color(color_hl);
		pi_putch('#');
	}
}
