/*
 * dml - Dialog Markup Language
 *
 * $Id: text_res.c,v 1.1 2001/05/18 13:08:02 malekith Exp $
 * Author: Michal Moskal <malekith@pld.org.pl>
 * include COPYING-GNU
 */

#include "pi.h"


const char *pi_text_res_fetch(struct pi_object *self)
{
	return ((struct pi_window*)self->parent)->text_res;
}

static struct pi_funcs text_res_funcs = {
	1,
	(pi_handler_void)pi_object_draw,
	(pi_handler_int)pi_object_cc,
	(pi_handler_int)pi_object_key,
	(pi_handler_void)pi_object_kill,
	(pi_handler_rstring)pi_text_res_fetch,
};

struct pi_object *pi_new_text_res(int size)
{
	struct pi_object *self;

	if (size == 0)
		size = sizeof(struct pi_object);
	self = pi_new_object(size);

	self->f = &text_res_funcs;

	return self;
}
