/*
 * dml - Dialog Markup Language
 *
 * $Id: output.c,v 1.1 2001/01/16 16:12:03 malekith Exp $
 * Author: Michal Moskal <malekith@pld.org.pl>
 * include COPYING-GNU
 */

#include "pi.h"
#include <string.h>
#include <unistd.h>
#include <stdio.h>

void pi_output(struct pi_window *win, int fd)
{
	char buf[4096];
	int p = 0, n;
	struct pi_id_info *id;
	const char *x;

	for (id = win->id_info; id; id = id->next) {
		if ((n = strlen(id->name)) + 4 + p >= (int)sizeof(buf)) {
			write(fd, buf, p);
			p = 0;
		}

		memcpy(buf + p, id->name, n);
		p += n;
		buf[p++] = '=';
		buf[p++] = '"';

		x = id->obj->f->fetch(id->obj);
		if (x) {
			for (; *x; x++) {
				if (p + 5 >= (int)sizeof(buf)) {
					write(fd, buf, p);
					p = 0;
				}
				if (strchr("$\"`", *x))
					buf[p++] = '\\';
				buf[p++] = *x;
			}
		}
		buf[p++] = '"';
		buf[p++] = '\n';
	}
	
	write(fd, buf, p);
	sprintf(buf, "res=%d\n", win->modal_result);
	write(fd, buf, strlen(buf));
}
