/*
 * dml - Dialog Markup Language
 *
 * $Id: checkbox.c,v 1.1 2001/01/16 16:12:03 malekith Exp $
 * Author: Michal Moskal <malekith@pld.org.pl>
 * include COPYING-GNU
 */

#include "pi.h"

void pi_checkbox_draw(struct pi_checkbox *self)
{
	pi_locate((struct pi_object*)self, 0, 0);
	
	pi_color(pi_is_active((struct pi_object*)self) ? 
			pi_color_checkbox_hl :
			pi_color_checkbox);
	pi_putch('[');
	pi_putch(self->checked ? 'X' : ' ');
	pi_putch(']');
}

void pi_checkbox_key(struct pi_checkbox *self, int key)
{
	if (key == ' ' || key == '\n') {
		self->checked = !self->checked;
		pi_draw((struct pi_object*)self);
	} else
		pi_object_key((struct pi_object*)self, key);
}

const char *pi_checkbox_fetch(struct pi_checkbox *self)
{
	return self->checked ? "yes" : "no";
}

static struct pi_funcs checkbox_funcs = {
	1,
	(pi_handler_void)pi_checkbox_draw,
	(pi_handler_int)pi_object_cc,
	(pi_handler_int)pi_checkbox_key,
	(pi_handler_void)pi_object_kill,
	(pi_handler_rstring)pi_checkbox_fetch,
};

struct pi_checkbox *pi_new_checkbox(int size)
{
	struct pi_checkbox *self;

	if (size == 0)
		size = sizeof(struct pi_checkbox);
	self = (struct pi_checkbox*)pi_new_object(size);

	self->f = &checkbox_funcs;

	return self;
}
