/*
 * dml - Dialog Markup Language
 *
 * $Id: nls.c,v 1.5 2001/05/15 16:21:09 malekith Exp $
 * Author: Michal Moskal <malekith@pld.org.pl>
 * include COPYING-GNU
 */

#include "phash.h"
#include "pi.h"
#include <unistd.h>
#include <fcntl.h>
#include <ctype.h>
#include <string.h>
#include <stdio.h>

#ifdef ENABLE_NLS
# define _(a) gettext(a)
# include <libintl.h>
# include <locale.h>
#else
# define _(a) (a)
#endif

#define MAX_LINE 4096

char *pi_nls_pp(const char *p, const char *domain, const char *dir)
{
	struct dbuf *db;
	char buf[MAX_LINE];
	char *out;
	int n;
	const char *msg;

	
	if (domain == 0)
		domain = "dml";
		
	/* FIXME: change this to some define, I don't know ... */
	if (dir == 0)
		dir = "/usr/share/locale";

	/* don't use LC_ALL here. it would require to
	 * few hundreds of useless data (LC_COLLATE etc)
	 * to be stored on boot flopy 
	 * also note that LANG=pl_PL and not pl for
	 * this to work, this seems to be bug in glibc 2.2
	 */
#ifdef ENABLE_NLS
	setlocale(LC_MESSAGES, "");
	bindtextdomain(domain, dir);
	textdomain(domain);
#endif
		
	db = db_new();
	
	while (*p) {
		if (p[0] != '{' || p[1] != '{') {
			db_addc(db, *p++);
			continue;
		}
		
		p += 2;
		for (n = MAX_LINE - 10, out = buf; n-- && *p; p++)
			if (*p == '}' && p[1] == '}') {
				p += 2;
				break;
			} else
				*out++ = *p;
				
		*out = 0;

		msg = _(buf);
		db_add(db, msg, strlen(msg));
	}
	
	db_addc(db, 0);
	
	return db_finish(db, 0);
}
