/*
 * dml - Dialog Markup Language
 *
 * $Id: fsbutton.c,v 1.1 2001/01/16 16:12:03 malekith Exp $
 * Author: Michal Moskal <malekith@pld.org.pl>
 * include COPYING-GNU
 */

#include "pi.h"

void pi_fsbutton_kill(struct pi_fsbutton *self)
{
	pi_button_kill((struct pi_button*)self);
	xfree(self->title);
}

void pi_fsbutton_key(struct pi_fsbutton *self, int key)
{
	char *file;
	
	if ((key != ' ' && key != '\n') || self->input == 0) {
		pi_object_key((struct pi_object*)self, key);
		return;
	}

	file = pi_select_file(self->input->buf, self->flags, self->title);
	pi_input_set_caption(self->input, file);
	self->super.parent->active = (struct pi_object*)self->input;
	pi_draw((struct pi_object*)self);
	pi_draw((struct pi_object*)self->input);
}

static struct pi_funcs fsbutton_funcs = {
	1,
	(pi_handler_void)pi_button_draw,
	(pi_handler_int)pi_object_cc,
	(pi_handler_int)pi_fsbutton_key,
	(pi_handler_void)pi_fsbutton_kill,
	(pi_handler_rstring)pi_button_fetch,
};

struct pi_fsbutton *pi_new_fsbutton(int size)
{
	struct pi_fsbutton *self;

	if (size == 0)
		size = sizeof(struct pi_fsbutton);
	self = (struct pi_fsbutton*)pi_new_button(size);

	self->super.f = &fsbutton_funcs;
	self->flags = PI_FSF_ALLOW_ALL;

	return self;
}
