/*
 * dml - Dialog Markup Language
 *
 * $Id: window.c,v 1.1 2001/01/16 16:12:03 malekith Exp $
 * Author: Michal Moskal <malekith@pld.org.pl>
 * include COPYING-GNU
 */

#include "pi.h"

void pi_window_draw(struct pi_window *self)
{
	int n, x, y;
	
	pi_color(pi_is_active((struct pi_object*)self) ? 
			pi_color_window_hl : pi_color_window);
	pi_locate((struct pi_object*)self, &x, &y);
	pi_frame(x, y, self->pos.w, self->pos.h);

	pi_goto(x + 1, y + 1);

	pi_fill(' ', x + 1, y + 1, self->pos.w - 2, self->pos.h - 2);
	
	if (self->title) {
		n = strlen(self->title);
		n += 2;
		
		if (n > self->pos.w - 2) {
			pi_goto(x + 1, y);
			pi_putch(' ');
			n = self->pos.w - 7;
			if (n > 0)
				pi_addstrn(self->title, n);
			pi_addstr("... ");
		} else {
			pi_goto(x + (self->pos.w - n) / 2, y);
			pi_putch(' ');
			pi_addstr(self->title);
			pi_putch(' ');
		}
	}

	pi_object_draw((struct pi_object*)self);
}

void pi_window_kill(struct pi_window *self)
{
	xfree(self->title);
}

void pi_window_cc(struct pi_window *self, int cc)
{
	self->modal_result = cc;
}

static struct pi_funcs window_funcs = {
	1,
	(pi_handler_void)pi_window_draw,
	(pi_handler_int)pi_window_cc,
	(pi_handler_int)pi_object_key,
	(pi_handler_void)pi_window_kill,
	(pi_handler_rstring)pi_object_fetch,
};

struct pi_window *pi_new_window(int size)
{
	struct pi_window *self;

	if (size == 0)
		size = sizeof(struct pi_window);
	self = (struct pi_window*)pi_new_object(size);

	self->f = &window_funcs;
	self->title = 0;

	return self;
}
