/*
 * dml - Dialog Markup Language
 *
 * $Id: phash.h,v 1.1 2001/01/16 16:12:03 malekith Exp $
 * Author: Michal Moskal <malekith@pld.org.pl>
 * include COPYING-GNU
 */

#define byte unsigned char
/* must be derived by phash objects: */
struct phash_entry {
	struct phash_entry *next;
	const char *name;
};

struct phash {
	unsigned int mask;	/* size of tab - 1 */
	unsigned int el;	/* number of elements */ 
	struct phash_entry **tab;
};

struct dbuf {
	byte *data;
	int size, off;
};

struct pstack {
	void **beg, **sp, **end;
};

void ph_add(struct phash *h, void *ee);
void *ph_find(struct phash *h, const char *name);
struct phash *ph_new();
void ph_std_kill(struct phash *h);
void ph_kill(struct phash *h, void (*kill_item)(struct phash_entry*));
void *ph_unlink(struct phash *h, const char *name);

/*
 * db - dynamic buffer
 */

struct dbuf *db_new();
void db_kill(struct dbuf *db);
void *db_finish(struct dbuf *db, int *size);
void *db_alloc(struct dbuf *db, int n);
void *db_add(struct dbuf *db, const void *data, int size);

#define db_addc(db, c) \
	(*((byte*)db_alloc((db), 1)) = (c))

#define db_addp(db, c) \
	(*((void**)db_alloc((db), sizeof(void*))) = (c))

#define db_data(db) (db->data)
#define db_off(db) (db->off)

/*
 * pstack - pointer stack
 */

struct pstack *pstack_new();
void pstack_kill(struct pstack *r);
int pstack_empty(struct pstack *r);
void *pop(struct pstack *r);
void *peek(struct pstack *r);
void push(struct pstack *s, void *val);
