/*
 * dml - Dialog Markup Language
 *
 * $Id: ml.h,v 1.1 2001/01/16 16:12:03 malekith Exp $
 * Author: Michal Moskal <malekith@pld.org.pl>
 * include COPYING-GNU
 */

#include "phash.h"

/*
 * Basic structre of parsed ml:
 * plain_text ... (pi_tag_start)(pi_tag_*)
 *		  ((pi_tag_arg)name(pi_tag_arg)value) *
 *		  (pi_tag_end) ... plain_text
 * ml: \t \n \001 \002 \003 are discarded from any input
 */

enum {
	pi_tag_eos = 0,
	pi_tag_start = 1,
	pi_tag_end = 2,
	pi_tag_arg = 3,

	pi_tag_label = 'A',
	
	pi_tag_b = 'a',
	pi_tag_e_b,
	pi_tag_i,
	pi_tag_e_i,
	pi_tag_br,
	pi_tag_text,
	pi_tag_e_text,
	pi_tag_input,
	pi_tag_button,
	pi_tag_meta,
	pi_tag_menu,
	pi_tag_e_menu,
	pi_tag_item,
	pi_tag_check,
};

#define PI_TAG_END	0x0001
#define PI_TAG_ARGS	0x0002
#define PI_TAG_TEXTAREA 0x0010
#define PI_TAG_MENU	0x0020
#define PI_TAG_NORMAL	0x0040
#define PI_TAG_ALL	0x00f0

struct pi_tag {
	int id;
	const char *name;
	int flags;
};


struct pi_amp {
	const char *name;
	int c;
};

struct pi_tag_arg {
	struct pi_tag_arg *next;
	char *name;
	char *val;
};

extern struct pi_tag pi_tags[];
extern struct pi_amp pi_amps[];

int pi_get_int(struct phash *tag_args, const char *name, int def);
char *pi_get_string(struct phash *tag_args, const char *name, char *def);
struct phash *pi_make_tag_args(char *p);
