/*
 * dml - Dialog Markup Language
 *
 * $Id: label.c,v 1.1 2001/01/16 16:12:03 malekith Exp $
 * Author: Michal Moskal <malekith@pld.org.pl>
 * include COPYING-GNU
 */

#include "pi.h"

void pi_label_draw(struct pi_label *self)
{
	pi_locate((struct pi_object*)self, 0, 0);
	pi_color(pi_color_label);
	pi_addstrn_fill(self->caption, self->pos.w);
}

void pi_label_kill(struct pi_label *self)
{
	xfree(self->caption);
}

static struct pi_funcs label_funcs = {
	0,
	(pi_handler_void)pi_label_draw,
	(pi_handler_int)pi_object_cc,
	(pi_handler_int)pi_object_key,
	(pi_handler_void)pi_label_kill,
	(pi_handler_rstring)pi_object_fetch,
};

struct pi_label *pi_new_label(int size)
{
	struct pi_label *self;

	if (size == 0)
		size = sizeof(struct pi_label);
	self = (struct pi_label*)pi_new_object(size);

	self->f = &label_funcs;
	self->caption = 0;

	return self;
}

struct pi_label *pi_add_label(struct pi_window *par, int x, int y, 
			      const char *s)
{
	struct pi_label *p;

	p = pi_new_label(0);
	pi_setpos((struct pi_object*)p, x, y, strlen(s), 1);
	pi_setstr(&p->caption, s);
	pi_add_child((struct pi_object*)par, (struct pi_object*)p);

	return p;
}
