/* 
 * file writen for bsp by 
 * Michal Moskal <malekith@pld.org.pl>
 * $Id: syscall.c,v 1.4 2001/07/24 15:36:38 malekith Exp $
 */

#include <sys/types.h>
#include <linux/types.h>
#include <syscall.h>
#include <signal.h>

int errno;

struct rusage;
struct utsname;
struct stat;

_syscall4(pid_t,wait4,pid_t,pid,int *,wait_stat,int,options,struct rusage *,rusage)
_syscall3(int,execve,const char *,file,char **,argv,char **,envp)
_syscall0(pid_t,fork)
#ifdef __sparc__
_syscall0(pid_t,getppid)
#endif
_syscall3(int,write,int,fd,const void *,buf,int,count)
_syscall3(int,read,int,fd,void *,buf,int,count)
_syscall1(void*,brk,void*,end)
_syscall2(int,kill,pid_t,pid,int,sig)
_syscall1(int,close,int,fd)
_syscall3(int,open,const char *,name,int,xx,int,mode)
_syscall3(off_t,lseek,int, fildes, off_t, offset, int, whence)
_syscall2(caddr_t,create_module,const char *,name, size_t, size)		     
_syscall1(int, delete_module,const char *,name)
_syscall5(int,query_module,const char *,name, int, which, void *,buf, size_t, bufsize, size_t *,ret)
_syscall1(int, uname,struct utsname *,buf)
_syscall2(int,stat,const char *,file_name, struct stat *,buf)
_syscall2(int,nanosleep,struct timespec *,a, struct timespec *,b)
_syscall3(int,ioctl,int,d,int,r,char *,p)
_syscall2(int,fstat,int,d,struct stat *,buf)

void usleep(int a)
{
	struct timespec t;
	t.tv_sec = a / 1000000;
	t.tv_nsec = a%1000000 * 1000;
	nanosleep(&t,NULL);
}

/* 
 * avoid braindemaged sunOS fork() return convetion of fork
 * don't-know-why followed by Linux ... w/o using any asm
 */
pid_t xfork()
{
	pid_t p;
	
	p = fork();

#ifdef __sparc__
	if (p == getppid())
		p = 0;
#endif

	return p;
}

int norm_stat(const char *file_name, struct stat *buf)
{
	return stat(file_name, buf);
}

/* avoid stupid warning about noreturn func, that returns */
#define __NR_trabka 1
static _syscall1(int,trabka,int,s)

void exit(int x)
{
	trabka(x);
	for(;;){}
}

void abort()
{
	kill(0,SIGABRT);
	for(;;){}
}

int *__errno_location(void)
{
	return &errno;
}
