/*
 * bsp - BrainDead Script Processor for initrd
 *
 * this falls under GNU GPL v2+.
 *
 * written in y2k by Michal Moskal <malekith@pld.org.pl>
 *
 * $Id: main.c,v 1.16 2001/07/24 15:46:21 malekith Exp $
 *
 */

#include "setup.h"	
#include <sys/types.h>
#include <linux/types.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/wait.h>

#define VERSION "0.2.0"
#define TEXT_VERSION "pi"

#define GREEN "\e[32m"
#define BOLD "\e[1m"
#define NOB "\e[21m"
#define CYAN "\e[36m"
#define RESET "\e[0m"
#define GRAY "\e[2m"
#define BLUE "\e[34m"
#define RED "\e[31m"

extern int main(int argc, char **argv);
char custom_path[MAX_NAME];
int insmod_exec(int argc, char **argv);
pid_t xfork();

void puts(char *s)
{
	char *p;
	for (p = s; *p; p++);
	write(2, s, p - s);
}

char buf[MAX_SIZE];

void split(char *s, char **argv)
{
	int d;
	char *a;
	
	while (*s) {
		while (*s == ' ' || *s == '\t')
			s++;

		a = s;
		while (*s && *s != ' ' && *s != '\t') {
			if (*s == '\'' || *s == '"') {
				d = *s++;
				while (*s && *s != d)
					s++;
			} else {
				s++;
			}
		}

		if (*s)
			*s++ = 0;

		*argv++ = a;
	}

	*argv = 0;
}

int do_echo(int argc, char **argv)
{
	(void)argc;
	argv++;
	puts(CYAN BOLD);
	while (*argv) {
		puts(*argv);
		puts(" ");
		argv++;
	}
	puts(RESET "\n");
	return 0;
}

int do_usleep(int argc, char **argv)
{
	if (argc != 2) {
		puts(RED BOLD "USAGE: usleep SEC\n" RESET);
	} else {
		usleep(atoi(argv[1]));
	}
	return 0;
}

int do_raid_oops(int argc, char **argv)
{
	puts(RED BOLD "Raid-less version!\n" RESET);
}

int do_sleep(int argc, char **argv)
{
	if (argc != 2) {
		puts(RED BOLD "USAGE: sleep SEC\n" RESET);
	} else {
		usleep(atoi(argv[1]) * 1000000);
	}
	return 0;
}

int do_modpath(int argc, char **argv)
{
	if (argc < 2)
		return 1;
	strcpy(custom_path, argv[1]);
	return 0;
}

struct bltin {
	const char *name;
	int fork;
	int (*exec)(int argc, char **argv);
};

int raidstart_main (int argc, char *argv[]);

struct bltin bltins[] = {
	{ "echo", 0, do_echo },
	{ "insmod", 1, insmod_exec },
	{ "modpath", 0, do_modpath },
	{ "sleep", 0, do_sleep },
	{ "usleep", 0, do_usleep },
	{ "raidstart", 1, raidstart_main },
	{ 0, 0, 0 }
};

char concat_buf[MAX_NAME];
char *concat(const char *s1, const char *s2)
{
	char *p;

	p = concat_buf;
	while (*s1)
		*p++ = *s1++;
	*p++ = '/';
	while (*s2)
		*p++ = *s2++;
	*p = 0;

	return concat_buf;
}

int can_read(const char *path)
{
	int fd;

	fd = open(path, 0, 0);
	if (fd == -1)
		return 0;
	close(fd);
	return 1;
}

int insmod_exec(int argc, char **argv)
{
	int i;
	char *mod_search[] = MOD_SEARCH_PATH;

	if (can_read(argv[1]))
		return main(argc, argv);
		
 	if (*custom_path && can_read(concat(custom_path,argv[1])))
 		goto ok;
 	
 	for (i = 0; mod_search[i]; i++)
 		if (can_read(concat(mod_search[i], argv[1]))) 
 			goto ok;
 	
 	puts(RED BOLD "cannot find module ");
 	puts(argv[1]);
 	puts(RESET "\n");
	return -1;

ok:
	argv[1] = concat_buf;
	return main(argc, argv);
}

int find_bultin(char **argv)
{
	int i;

	for (i = 0; bltins[i].name; i++)
		if (strcmp(bltins[i].name, argv[0])==0)
			break;
	if (bltins[i].name == 0)
		i = -1;
	return i;
}

int try_exec(char **argv)
{
	char *env[] = INIT_ENV;
	int pid, s;
	char *p[] = SEARCH_PATH;
	int i; 

	i = find_bultin(argv);

	if (i == -1 || bltins[i].fork) {
		pid = xfork();
		if (pid == -1) {
			puts(RED BOLD "fork() failed\n" RESET);
			exit(2);
		}

		if (pid) {
			wait4(pid, &s, 0, 0);
			return s / 256;
		}
	}

	if (i != -1) {
		pid = 0;
		while (argv[pid])
			pid++;
		pid = bltins[i].exec(pid, argv);
		if (bltins[i].fork)
			exit(pid);
		else
			return pid;
	}
	
	if (**argv == '.' || **argv == '/')
		execve(argv[0], argv, env);
	else 
		for (i = 0; p[i]; i++) 
			execve(concat(p[i], argv[0]), argv, env);
	
	exit(127);
}

void exec(char *s)
{
	char *argv[MAX_ARGV];
	int r;
	
	split(s, argv);

	r = try_exec(argv);

	if (r) {
		puts(RED BOLD "execution of ");
		puts(argv[0]);
		puts(" FAILED\n" RESET);
	}
}

void execute_line(char *s)
{
	while (*s == ' ' || *s == '\t')
		s++;
	if (*s == '#')
		return;
		
	if (*s == '@')
		s++;
	else if (*s == 0)
		return;
	else if (*s == '>') {
		s++;
		while (*s == ' ' || *s == '\t')
			s++;
		puts(CYAN BOLD);
		puts(s);
		puts(RESET "\n");
		return;
	} else {
		puts(CYAN BOLD "+ " NOB);
		puts(s);
		puts(RESET "\n");
	}

	exec(s);
}

void parse(char *s)
{
	char *e;
	
	while (*s) {
		for (e = s; *e; e++)
			if (*e == '\n')
				break;
		if (*e)
			*e++ = 0;

		execute_line(s);
		s = e;
	}
}

void xstart()
{
	int fd;
	int i;
	char *p[] = STARTUP_PATH;
	
	puts(
	     GREEN BOLD "B" NOB "raindamaged " BOLD "S" NOB "cript " 
	     BOLD "P" NOB "rocessor for initrd v"
	     BOLD VERSION NOB " - [" BOLD TEXT_VERSION NOB "]\n"
	     RESET);


	for (i = 0; p[i]; i++) {
	/*
		puts(GREEN "Trying " BOLD);
		puts(p[i]);
		puts(NOB " ... ");
		*/
		fd = open(p[i], 0, 0);
		
		if (fd == -1) {
		/*	puts("nope.\n" RESET); */
		} else {
/*			puts(BOLD "yap " NOB "!\n" RESET);*/
			break;
		}
	}
	
	if (fd == -1) {
		puts(RED BOLD "opening startup file failed\n" RESET);
		exit(1);
	}

	read(fd, buf, sizeof(buf));
	close(fd);

	puts("\n");
	
	parse(buf);
	
	puts("\n");
	
	puts(RESET GREEN BOLD "M" NOB "ay the " BOLD "penguin" 
	     NOB " be with you.\n" RESET);
	exit(0);
}
