/* 
 * file modified for static insmod inside bsp by 
 * Michal Moskal <malekith@pld.org.pl>
 * $Id: string.c,v 1.1 2000/12/06 11:30:52 malekith Exp $
 */

/* $Id: string.c,v 1.1 2000/12/06 11:30:52 malekith Exp $ */
#include <sys/types.h>

#ifndef __HAVE_ARCH_STRLEN
unsigned int strlen(const char *p)
{
	const char *pp;
	pp = p;
	while (*pp)
		pp++;
	return pp - p;
}
#endif

#ifndef __HAVE_ARCH_MEMCPY
void *memcpy(void *p, const void *s, size_t n)
{
	char *pp;
	const char *ss;
	
	if (n == 0) return p;
	pp = p;
	ss = s;
	
	while (n--)
		*pp++ = *ss++;
	return p;
}
#endif

#ifndef __HAVE_ARCH_STRNCMP
int strncmp(const char *a, const char *b, size_t p)
{
	if (p == 0)
		return 0;
		
	while (*a && *a == *b && p--)
		a++, b++;
	if (*a == *b || p == 0)
		return 0;
	if (*a < *b)
		return -1;
	else
		return +1;
}
#endif

#ifndef __HAVE_ARCH_STRCMP
int strcmp(const char *a, const char *b)
{
	while (*a && *a == *b)
		a++, b++;
	if (*a == *b)
		return 0;
	if (*a < *b)
		return -1;
	else
		return +1;
}
#endif

#ifndef __HAVE_ARCH_STRCHR
char *strchr(const char *p, int c)
{
	if (c == 0) {
		while (*p)
			p++;
		return (char*)p;
	}
	while (*p && *p != c)
		p++;
	if (*p)
		return (char*)p;
	else
		return 0;
}
#endif

#ifndef __HAVE_ARCH_STRCPY
char *strcpy(char *d, const char *s)
{
	char *p = d;
	while (*s)
		*p++ = *s++;
	*p = 0;
	return d;
}
#endif

#ifndef __HAVE_ARCH_STRNCPY
char *strncpy(char *d, const char *s, size_t n)
{
	char *p = d;
	
	if (n == 0)
		return d;
	n--;
	do {
		*p++ = *s;
	} while (*s++ && n--);
	
	return d;
}
#endif

#ifndef __HAVE_ARCH_MEMMOVE
/* stolen from linux kernel */
void *memmove(void *dest, const void *src, size_t count)
{
	char *tmp, *s;

	if (dest <= src) {
		tmp = (char *) dest;
		s = (char *) src;
		while (count--)
			*tmp++ = *s++;
	} else {
		tmp = (char *) dest + count;
		s = (char *) src + count;
		while (count--)
			*--tmp = *--s;
	}

	return dest;
}
#endif

#ifndef __HAVE_ARCH_MEMSET
void *memset(void *d, int c, size_t n)
{
	unsigned char *p;

	if (n == 0)
		return d;
		
	p = d;
		
	while (n--)
		*p++ = c;
		
	return d;		
}
#endif

char *strcat(char *dest, const char *src)
{
	char *tmp;
	
	tmp = dest;
	
	while (*dest)
		dest++;
	while (*src)
		*dest++ = *src++;
	*dest = 0;
	return tmp;
}

char * strrchr(const char * s, int c)
{
       const char *p = s + strlen(s);
       do {
           if (*p == (char)c)
               return (char *)p;
       } while (--p >= s);
       return 0;
}

char * strstr(const char * s1,const char * s2)
{
	int l1, l2;

	l2 = strlen(s2);
	if (!l2)
		return (char *) s1;
	l1 = strlen(s1);
	while (l1 >= l2) {
		l1--;
		if (!memcmp(s1,s2,l2))
			return (char *) s1;
		s1++;
	}
	return 0;
}

void *malloc(size_t);
char *strdup(const char *src)
{
	return strcpy(malloc(strlen(src) + 1), src);
}

int memcmp(const void * cs,const void * ct,size_t count)
{
	const unsigned char *su1, *su2;
	signed char res = 0;

	for( su1 = cs, su2 = ct; 0 < count; ++su1, ++su2, count--)
		if ((res = *su1 - *su2) != 0)
			break;
	return res;
}

size_t strnlen(const char * s, size_t count)
{
	const char *sc;

	for (sc = s; count-- && *sc != '\0'; ++sc)
		/* nothing */;
	return sc - s;
}
