/* 
 * file modified for static insmod inside bsp by 
 * Michal Moskal <malekith@pld.org.pl>
 * $Id: logger.c,v 1.1 2000/12/06 11:30:52 malekith Exp $
 */

/* Error logging facilities.
   Copyright 1996, 1997 Linux International.

   Contributed by Richard Henderson <rth@tamu.edu>

   This file is part of the Linux modutils.

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2 of the License, or (at your
   option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
  */

#ident "$Id: logger.c,v 1.1 2000/12/06 11:30:52 malekith Exp $"

#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <errno.h>
#include <unistd.h>

#include "util.h"

/*======================================================================*/

int log;
static int silent;

int errors;
const char *error_file;
const char *program_name;


void error(const char *fmt,...)
{
	va_list args;

	if (silent)
		;
	else {
		char buf[1024];
		int n;

		if (error_file)
			n = sprintf(buf, "%s: ", error_file);
		else
			n = 0;
		va_start(args, fmt);
		vsprintf(buf + n, fmt, args);
		va_end(args);
		
		write(2,buf,strlen(buf));
		write(2,"\n",1);
	}

	errors++;
}
