/* 
 * file writen for static insmod inside bsp by 
 * Michal Moskal <malekith@pld.org.pl>
 * $Id: alloc.c,v 1.1 2000/12/06 11:30:52 malekith Exp $
 */

#include <sys/types.h>
#include "util.h"

static void *end, *ptr;

void abort();
void *brk(void *end);

void *malloc(size_t s)
{
	void *r;

	s += sizeof(void*)-1;
	s &= ~(sizeof(void*)-1);
	if (end == 0) {end=ptr=brk(0);}
	if (ptr+s>end){end=brk(ptr+s+4096);}
	if (ptr+s>end)abort();
	r = ptr;
	ptr += s;
	return r;
}

void free(void *ptr)
{
	(void)ptr;
}

void *realloc(void *ptr, size_t s)
{
	void *n;
	size_t x;

	if (ptr == 0) return malloc(s);
	n = malloc(s);
	x = s;
	if (x > n - ptr)
		x = n - ptr;
	memcpy(n, ptr, x);
	return n;
}

void assert_fail(const char *name, const char *file, int line, 
		 const char *func)
{
	error("%s:%d: assertion %s failed in %s", file,line,name,func);
	abort();
}
