#!/bin/sh

name="sdcc"
title="SDCC"
package="sdcc"
version="2.3.0"
build="1.4"
noarch="n"
build_info="Standard build."

info="Retargettable, optimizing ANSI-C compiler for the 8051 MCU."
desc="SDCC is a freeware, retargettable, optimizing ANSI-C compiler.
The current version targets Intel 8051-based MCUs, the Zilog
Z80, and the DS390. Targets for the Microchip PIC and Amtel
AVR series are under development, and the compiler can be
retargeted for other 8 bit MCUs or PICs. The entire source
code for the compiler is distributed under GPL. SDCC uses
ASXXXX and ASLINK, a freeware, retargettable assembler and
linker. SDCC has extensive MCU (8051)-specific language
extensions, which lets it utilize the underlying hardware
effectively. It includes a source-level debugger/simulator
and can generate debug info for the NoICE debugger."
category="development/compiler"
environment="console/text"
contact="$name@packages.packware.one.pl"
vendor="The Packware Project"
vendor_id="pw"

requires=""
obsoletes=""
conflicts=""

docs_source="doc/{KNOWNBUGS.txt,README.txt,cdbfile.html,choices.txt,random-notes.txt,sdccman.txt,test_suite_spec.txt}"
docs_cwd=""

strip_bin="y"
reset_own="y"
reset_dir="y"
reset_fil="y"
delete_cat="y"

. /usr/src/tgz/lib/builder.defs

add_source http://belnet.dl.sourceforge.net/sourceforge/sdcc/$name-$version.tar.gz $name

configure_option --prefix=/usr

install_option prefix=$pkg_main/usr

parent_package="$package"
write_info main

cd $src1

do_configure
do_make
do_install

mv $pkg_main/usr/doc/ucsim $doc_dir
mv $pkg_main/usr/share/doc/sdcc/aslink $doc_dir
mv $pkg_main/usr/share/doc/sdcc/avr/avr_design.txt $doc_dir
rm -rf $pkg_main/usr/share/doc
rm -rf $pkg_main/usr/share/sdcc/include/asm/CVS
rm -rf $pkg_main/usr/share/sdcc/include/asm/*/CVS
rm -rf $pkg_main/usr/share/sdcc/lib/src/*/CVS
rm -rf $pkg_main/usr/share/sdcc/lib/src/ds390/examples/CVS

make_docs

make_package main

clean_up

# $Log: sdcc.builder,v $
# Revision 1.4  2003/02/10 14:36:46  swiergot
# - Fixed docs cleaning.
#
# Revision 1.3  2003/02/10 14:20:03  swiergot
# - Put docs in right place.
# - Remove CVS control directories.
#
# Revision 1.2  2003/02/10 13:43:47  swiergot
# - Fixed source topdir.
#
# Revision 1.1  2003/02/10 13:15:39  swiergot
# - Initial release.
# - Version 2.3.0.
#
