#!/bin/sh

name="qssl"
title="QSSL"
package="qssl"
version="2.0"
build="1.3"
noarch="n"
build_info="Standard build."

info="Psi plugin for using SSL."
desc="QSSL is a plugin that allows Psi to make SSL-secured connections.
What is more, this plugin can be used with other Qt-based
applications if they know what to do with it."
category="security/ssl"
environment="plugin"
contact="$name@packages.packware.one.pl"
vendor="The Packware Project"
vendor_id="pw"

requires=""
obsoletes=""
conflicts=""

docs_source="README"
docs_cwd=""

strip_bin="y"
reset_own="y"
reset_dir="y"
reset_fil="y"
delete_cat="y"

. /usr/src/tgz/lib/builder.defs

add_source http://osdn.dl.sourceforge.net/sourceforge/psi/$name-$version.tar.bz2

export QTDIR=/usr/lib/qt

parent_package="$package"
write_info main

cd $src1

qmake qssl.pro

apply_patch optflags

do_make

msg_installing

copy libqssl.so $pkg_main/usr/share/psi

make_docs

make_package main

clean_up

# $Log: qssl.builder,v $
# Revision 1.11  2003/06/17 15:55:24  swiergot
# - Fixed optflags patch applying.
#
# Revision 1.10  2003/06/17 15:40:12  swiergot
# - Use official source distribution.
# - Added optflags patch.
#
# Revision 1.9  2003/06/06 18:40:21  swiergot
# - Updated for Psi 0.9.
# - Version 2.0.
#
# Revision 1.8  2003/04/08 11:43:08  swiergot
# - Build 1.
#
# Revision 1.7  2003/04/08 11:37:59  swiergot
# - Commited new sources from Psi CVS.
# - Let's call it version 1.1 :-)
#
# Revision 1.6  2003/03/15 17:38:09  swiergot
# - Build 3.
#
# Revision 1.5  2003/03/15 17:20:04  swiergot
# - Changed prefix to /usr.
#
# Revision 1.4  2003/02/03 15:20:25  swiergot
# - Build 2.
#
# Revision 1.3  2003/01/27 17:15:43  swiergot
# - Changed prefix from /usr to /opt/kde.
#
# Revision 1.2  2002/12/25 22:37:51  swiergot
# - Build 1.
#
# Revision 1.1  2002/12/25 22:13:55  swiergot
# - Initial release.
# - Version 1.0.
#
