#!/bin/sh

name="php"
title="PHP"
package="php"
version="4.3.2"
build="1.2"
noarch="n"
build_info="Standard build."

info="High-level scripting language."
desc="PHP is a widely-used Open Source general-purpose scripting
language that is especially suited for Web development and
can be embedded into HTML. Its syntax draws upon C, Java,
and Perl, and is easy to learn. PHP runs on many different
platforms and can be used as a standalone executable or as
a module under a variety of Web servers. It has excellent
support for databases, XML, LDAP, IMAP, Java, various
Internet protocols, and general data manipulation, and is
extensible via its powerful API. It is actively developed
and supported by a talented and energetic international
team. Numerous Open Source and commercial PHP-based
application packages are available."
category="development/compiler"
environment="console/text"
contact="$name@packages.packware.one.pl"
vendor="The Packware Project"
vendor_id="pw"

requires=""
obsoletes=""
conflicts=""

docs_source="CODING_STANDARDS,CREDITS,EXTENSIONS,INSTALL,LICENSE,NEWS,README*,TODO"
docs_cwd=""

strip_bin="y"
reset_own="y"
reset_dir="y"
reset_fil="y"
delete_cat="y"

. /usr/src/tgz/lib/builder.defs

add_source http://www.php.net/distributions/$name-$version.tar.bz2

configure_option --prefix=/usr
configure_option --with-apxs2
configure_option --enable-force-cgi-redirect
configure_option --enable-discard-path
configure_option --with-config-file-path=/etc/apache
configure_option --enable-safe-mode
configure_option --with-openssl
configure_option --enable-bcmath
configure_option --with-bz2
configure_option --enable-pic
configure_option --enable-calendar
configure_option --enable-ctype
configure_option --with-gdbm
configure_option --with-db3
configure_option --enable-dbase
configure_option --enable-ftp
configure_option --enable-gd-native-ttf
configure_option --with-gmp
configure_option --with-mysql=/usr
configure_option --with-xml=shared
configure_option --with-mm=/usr
configure_option --enable-trans-sid
configure_option --enable-shmop
configure_option --enable-sockets
configure_option --with-regex=php
configure_option --enable-sysvsem
configure_option --enable-sysvshm
configure_option --enable-yp
configure_option --enable-memory-limit
configure_option --with-tsrm-pthreads
configure_option --enable-shared
configure_option --disable-static
configure_option --disable-debug
configure_option --with-zlib=/usr

install_option INSTALL_ROOT=$pkg_main

parent_package="$package"
write_info main

cd $src1

chown -R `id -u`.`id -g` .
find . -perm 777 -exec chmod 755 {} \;
find . -perm 775 -exec chmod 755 {} \;
find . -perm 666 -exec chmod 644 {} \;
find . -perm 664 -exec chmod 644 {} \;
find . -name "*.h" -exec chmod 644 {} \;

do_configure
do_make
do_install

( 
cd $pkg_main/usr/lib/php
find . -perm 666 -exec chmod 644 {} \;
)

copy php.ini-dist $pkg_main/etc/apache
copy php.ini-recommended $pkg_main/etc/apache
copy $src_pkg/mod_php.conf.example $pkg_main/etc/apache

make_docs

rm -f $pkg_main/usr/doc/$name-$version/README.QNX

subpackage apache2
subpackage devel

make_package main
make_package apache2
make_package devel

clean_up

# $Log: php.builder,v $
# Revision 1.25  2003/05/30 20:48:19  swiergot
# - Well, removed configure_option --with-db2 :-)
#
# Revision 1.24  2003/05/30 20:29:38  swiergot
# - Version 4.3.2.
# - Removed gd-related code. Use bundled gd.
# - Fixed gd related configure_option directives.
# - Removed --with-db2 as since this version PHP doesn't allow to use more
#   than one db version.
#
# Revision 1.23  2003/05/28 16:22:38  swiergot
# - Build 2.
#
# Revision 1.22  2003/05/28 16:11:36  swiergot
# - Fixed mod_php.conf.
#
# Revision 1.21  2003/05/28 13:34:14  swiergot
# - Build 1.
#
# Revision 1.20  2003/05/28 10:20:01  swiergot
# - Version 4.3.1.
# - Fixed subpackages.
#
# Revision 1.19  2003/01/13 19:40:14  swiergot
# - Defined subpackages.
#
# Revision 1.18  2003/01/13 18:20:43  swiergot
# - Added --enable-ctype.
# - Cleanups.
#
# Revision 1.17  2003/01/13 13:50:10  swiergot
# - CLI is built correctly. Time to enable apxs2.
#
# Revision 1.16  2003/01/13 13:31:00  swiergot
# - Hmm... looks like we can build standalone php and Apache module at once.
#
# Revision 1.15  2003/01/13 13:08:29  swiergot
# - Debug: once again the same.
#
# Revision 1.14  2003/01/13 12:56:44  swiergot
# - Debug: checking whether additional parameters for do_configure work.
#
# Revision 1.13  2003/01/13 12:35:46  swiergot
# - Fixed disabling apxs2 in first configure.
# - Fixed copying configuration files.
#
# Revision 1.12  2003/01/13 12:26:17  swiergot
# - Preserve configure before enabling axps2.
#
# Revision 1.11  2003/01/13 11:41:12  swiergot
# - Force building.
#
# Revision 1.10  2003/01/12 22:16:02  swiergot
# - Of course, we can't chown to root.root. Chown to `id -u`.`id -g` instead.
#
# Revision 1.9  2003/01/12 21:52:15  swiergot
# - Actually, most of php.builder has been rewritten basing on script used to
#   build PHP in Slackware. This includes gd compiling and statically linking
#   as well. Now our package is fully compatible with the one from Slackware.
#
# Revision 1.8  2002/12/29 22:24:43  swiergot
# - Commented out configure_option for XSLT as we don't have any backend.
#
# Revision 1.7  2002/12/29 22:13:27  swiergot
# - Removed configure_option for readline as it doesn't work.
#
# Revision 1.6  2002/12/29 21:50:02  swiergot
# - Commented out configure_option for LDAP as we don't have this available.
#
# Revision 1.5  2002/12/29 21:37:48  swiergot
# - Commented out all configure_option for IMAP as we don't have proper IMAP
#   available.
#
# Revision 1.4  2002/12/29 21:29:51  swiergot
# - Removed configure_option for --with-dbm.
# - Don't copy out config.log.
#
# Revision 1.3  2002/12/29 21:01:00  swiergot
# - Copy out config.log.
#
# Revision 1.2  2002/12/29 20:43:48  swiergot
# - Commented out configure_option --with-curl as we don't have a proper
#   version of CURL yet.
#
# Revision 1.1  2002/12/29 20:20:52  swiergot
# - Initial release.
# - Version 4.3.0.
#
