#!/bin/sh

name="nvclock"
title="NVClock"
package="nvclock"
version="0.6.2"
build="1.1"
noarch="n"
build_info="Standard build."

info="An overclocking and tweaking tool for NVidia cards."
desc="NVClock has the following features: overclocking on all
NVidia cards except for the Riva128/Riva128zx; command line
interface; GTK/GTK2 interface; Qt interface; support for
multiple cards; card information."
category="multimedia/soundserver"
environment="x11/qt"
contact="$name@packages.packware.one.pl"
vendor="The Packware Project"
vendor_id="pw"

requires=""
obsoletes=""
conflicts=""

docs_source="ABOUT,AUTHORS,COPYING,ChangeLog,FAQ,INSTALL,README"
docs_cwd=""

strip_bin="y"
reset_own="y"
reset_dir="y"
reset_fil="y"
delete_cat="y"

. /usr/src/tgz/lib/builder.defs

add_source http://www.linuxhardware.org/nvclock/$name$version.tar.gz

configure_option --prefix=/usr

install_option DESTDIR=$pkg_main

parent_package="$package"
write_info main

cd $src1

do_configure
do_make
do_install

make_docs

make_package main

clean_up

# $Log: nvclock.builder,v $
# Revision 1.1  2003/04/20 20:15:10  swiergot
# - Initial release.
# - Version 0.6.2.
#
