/*************************************************
**      To: qt_nvclock.h
** Project: nvclock
**  Author: Jan Prokop
**  e-mail: jprokop@ibl.sk
*************************************************/

#ifndef QT_NVCLOCK
#define QT_NVCLOCK

#include <qtabdialog.h>
#include <qtextbrowser.h>

#include "nvclock.h"

class QLabel;
class QSpinBox;
class QCheckBox;
class QComboBox;
class QGroupBox;
class QGridLayout;

//------------------------------------------------------------------

class CTabNVidia : public QWidget {
    Q_OBJECT
        
public:
    CTabNVidia(QWidget *parent, char *name);

public slots:
    int  slotGo();
    int  slotLoad(int id);
    
private:
    QComboBox   *comboCardNo;
    QSpinBox    *spinCore, *spinMemory;
    QCheckBox   *checkDebug;
    QGridLayout *l;
    QGroupBox   *cardInfo, *agpInfo;

    QLabel *labelGPUName, *labelBustype, *labelMemorySize, *labelMemoryType;
    QLabel *labelAGPstatus, *labelSupAGPrates, *labelAGPrate;
    QLabel *labelFWstatus, *labelSBAstatus;

    //struct card nvcard[10];
    int  total_cards;

    void addLabel(const QString &text, int yy);
    void initCardInfo(int posy);
    void initAGPInfo(int posy);

    int  loadCardInfo(const struct card_info *nv_info);
    int  loadAGPInfo(const struct card_info *nv_info);

    int  getCards();
};

//------------------------------------------------------------------
              
class CNVclock : public QTabDialog {
    Q_OBJECT

public:
    CNVclock(QWidget *parent, char *name);
};
#endif
