/*
NvClock

version 0.6.2
-fixed a serious bug in the overclocking code from nvclock 0.6.1
-fixed a bug that broke multiple card support in 0.6.1

version 0.6.1
-GeforceFX/QuadroFX support (untested)
-support for driver version 1.0-4XXX
-improved QT gui
-various other bugfixes

version 0.6.0
-NV18 and NV18-GL support (untested)
-GTK 2.x support
-improved GTK gui
-fixed multiple card support
-fixed some speed limits
-additional card info from card registers
-code cleanups

version 0.5.0
-new calculation code
-more working speeds
-lots of cleanups
-overclocking by non-root users when using the closed source nVidia drivers
-fixed "fake ddr" bug for Geforce2MX/Geforce4MX using sdr memory
-27MHz crysthal frequency support which is needed for Geforce4 based cards
-support for Geforce4 Ti/MX and Quadro4 XGL/NVS (as yet untested) 
-disabled some cards (nForge, Xbox GPU, Mobile GPU's)

version 0.4.2
-fixed a bug for overclocking the memory of the geforce3  
-changed geforce3 mx/ultra to titanium 200/500

version 0.4.1
-geforce3 mx/ultra and quadro dcc support
-little calculation bugfix

version 0.4.0
-geforce2 pro/ultra and geforce3 support
-new pci code
-card identifying code
-gtk/qt gui
-support for multiple cards

version 0.2.0
-better commandline handling
-geforce2 (gts, pro, ultra) bugs fixed (still not working well :( )


version: 0.1.1
-more code cleanups (thanks phoenix)
-better commandline handling
-root warning

version: 0.1
-easier to work with
-code cleanups
Roderick Colenbrander

version: 0.01 Basic Overclock program (nvcs)
Anonymous (I don't know who made the first nv overclocking program)

site: nvclock.sourceforge.net 
projectpage: www.sourceforge.net/projects/nvclock

*/


#ifdef __FREEBSD__
#include <unistd.h>
#else
#include <getopt.h>
#endif

#include "nvclock.h"


int usage() 
{
    printf("With this program you can overclock your nvidia card under linux.\nUse this program at your own risk, because it can damage your system!\n\n");
    printf("Usage: ./nvclock [options]\n\n");
    printf("Overclock options:\n");
    printf("   -c  --card number\t\tNumber of the card to overclock\n");
    printf("   -m  --memclk speed\t\tMemory speed in MHz\n");
    printf("   -n  --nvclk speed\t\tCore speed in MHz\n\n");
    printf("Other options:\n");	
    printf("   -d  --debug\t\t\tEnable/Disable debug info\n");
    printf("   -f  --force\t\t\tForce a speed, nvclock won't check min/max speeds\n");
    printf("   -h  --help\t\t\tShow this help info\n");
    printf("   -i  --info\t\t\tPrint detailed card info\n");
    printf("   -s  --speeds\t\t\tPrint current speeds in MHz\n\n");
    return 0;
}

int main(int argc, char *argv[])
{
    unsigned int card_number, total_cards;   
    float memclk, nvclk;
    const struct card_info *nv_info;
    int i, opt, debug, info, speeds, force, card_;
    

    static struct option long_options[] = {
        {"memclk", 1, 0, 'm'},
        {"nvclk", 1, 0, 'n'},
        {"card", 1, 0, 'c'},
        {"force", 0, 0, 'f'},
	{"info", 0, 0, 'i'}, 
        {"speeds", 0, 0, 's'},
	{"debug", 0, 0, 'd'},
	{"help", 0, 0, 'h'},
	{0, 0, 0, 0}
    };

    debug = 0;
    force = 0;
    speeds = 0;
    info = 0;
    card_ = 0;
    card_number = 0;
    total_cards = -1;
    memclk = 0;
    nvclk = 0;

    printf("\n=======================\n");
    printf("--- NvClock v0.6.2 ---\n");
    printf("=======================\n\n");

    total_cards = FindAllCards();


    switch(total_cards)
    {
	/* If no cards found, exit. */
	case -1:
	    printf("No nVidia card found in your system!\n");
	    exit(1);
	    break;
	case -2:
	    printf("You don't have permissions to access the registers of your Nvidia card.\n");
	    printf("Try to run nvclock as root to get access to /dev/mem or install the Nvidia 3d drivers to use /dev/nv* instead.\n");
	    printf("Remember only root can access /dev/mem, most users can access /dev/nv*.\n");
	    exit(1);
	    break;
	default:
	    break;
    }

    /* If no options are given. */
    if ( argc == 1 ) {	
        usage();
	return 0;
    }

    /* If no cards found, exit. */
    if(total_cards < 0)
    {
	printf("No nVidia card found in your system!\n");
	return 0;
    }

    while ( ( opt = getopt_long (argc, argv, "m:n:c:lfidsh", long_options, NULL)) != -1 )
    {
	switch (opt)
	{
	    case 'c':
		card_number = strtol(optarg, (char **)NULL, 10)-1;
		card_ = 1;
		break;

	    case 'd':
		debug = 1; 
	        break;

	    case 'f':
		force = 1; 
	        break;

	    case 'i':
		info = 1;
		break;
	    
	    case 'm':
		memclk = strtol(optarg, (char **)NULL, 10);
		
		if (memclk > 0) { ; }
		else
		{
	    	    printf("wrong value of memclk %d\n", memclk);
	    	    return 1;
		}
		break;

	    case 'n':
		nvclk = strtol(optarg, (char **)NULL, 10);
		
		if (nvclk > 0) { ; } 
		else
		{
	    	    printf("wrong value of nvclk %d\n", nvclk);
		    return 1;
		}
        	break;
	    
	    case 's':
		speeds = 1;
        	break;

	    case 'h':
		default:
		usage();
		return 0;
        }
    }

    /* Check if the user used the -s option, if so show the requested info. */
    if( speeds == 1)
    {
	i = 0;
	card_number = 0;

	while(i <= total_cards)
	{
	    GetSpeeds(&memclk, &nvclk, i, debug);
	    nv_info = GetCardInfo(i);

	    printf("Card: \t\t%s\n", nv_info->device_string);
	    printf("Card number: \t%d\n", i+1);
    	    printf("Memory speed: \t%0.3f MHz\n", memclk); 
    	    printf("Core speed: \t%0.3f MHz\n\n", nvclk); 
	    i++;
	}
	
	return 0;
    }

    if( info == 1)
    {
	nv_info = GetCardInfo(card_number);
        GetSpeeds(&memclk, &nvclk, card_number, debug);

	printf("-- General info --\n");
	printf("Card: \t\t%s\n", nv_info->device_string);
        printf("PCI id: \t0x%x\n", nv_info->device_id ); 
        printf("GPU speed: \t%0.3f MHz\n", nvclk); 
	printf("Bustype: \t%s\n\n", nv_info->bus_type);
    
	printf("-- Memory info --\n");
	printf("Amount: \t%d MB\n", nv_info->memory_size);
	printf("Type: \t\t%d bit %s\n", nv_info->memory_width, nv_info->memory_type);
        printf("Speed: \t\t%0.3f MHz\n\n", memclk); 
	
	if(strstr(nv_info->agp_status, "Enabled") != 0)
	{
	    printf("-- AGP info --\n");
    	    printf("Status: \t%s\n", nv_info->agp_status);
	    printf("Rate: \t\t%dX\n", nv_info->agp_rate);
	    printf("AGP rates: \t%s\n", nv_info->agp_support_rate);

	    if(strstr(nv_info->fw_status, "Enabled") != 0)
		printf("Fast Writes: \t%s\n", nv_info->fw_status);
	    else
	        printf("Fast Writes: \t%s, %s\n", nv_info->fw_support, nv_info->fw_status);
	    
	    if(strstr(nv_info->sba_status, "Enabled") != 0)
		printf("SBA: \t\t%s\n\n", nv_info->sba_status);
	    else
		printf("SBA: \t\t%s, %s\n\n", nv_info->sba_support, nv_info->sba_status);
	}
	
	return 0;
    }
    
    /* Check if the user entered more than only the card number. */
    if( card_ = 1 && (memclk == 0 && nvclk == 0) )
    {
	usage();
	return 0;    
    }

    /* Check if the card number is valid. */
    if((card_number+1) <= 0)
    {
	printf("The card number you entered is invalid!\nIt needs to be bigger than 0.\nPlease try again.\n\n");
	return 0;
    }

    /* Check if the card number isn't bigger than the max number of cards. */
    if( card_number > total_cards)
    {
	printf("The card number you have selected is invalid.\nYou only have %d NVIDIA cards in your system and you selected card %d.\nPLease try again.\n\n", total_cards+1, card_number+1);
	return 0;
    }

    nv_info = GetCardInfo(card_number);


    /* Check if the card is supported, if not print a message. */
    if(nv_info->supported == 0 && force == 0)
    {
	printf("It seems your card isn't officialy supported in Nvclock yet.\n");
	printf("The reason can be that your card is too new.\n");
	printf("If you want to try it anyhow [DANGEROUS], use the option -f to force the setting(s).\n");
	printf("Also please email the author the pci_id of the card for further investigation.  [Get that value using the -s option].\n\n");
	return 0;
    }
    
    
    
    /* Check if the speed is higher than the max speed, if not print a message. */
    if( (memclk >= nv_info->memclk_max || nvclk >= nv_info->nvclk_max) && force == 0)
    {
	printf("Warning!\n");
	printf("Some of the speeds you entered seem to be a bit too high for the card type!\n\n");
	printf("You entered a memory speed of %.3f MHz and nvclock believes %d.000 MHz is the maximum!\n", memclk, nv_info->memclk_max);
	printf("You entered a core speed of %.3f MHz and nvclock beleives %d.000 MHz is the maximum!\n", nvclk, nv_info->nvclk_max);
	printf("If you really want to use this speed, use the option -f to force the setting(s).\n\n");
	printf("\n");
	return 0;
    }


    if( memclk == 0)
    {
	float t_nvclk;
	GetSpeeds(&memclk, &t_nvclk, card_number, debug);
	printf("Keeping current memory clock:\t%0.3f MHz\n", memclk);
    }

    else if (nvclk == 0)
    {
        float t_memclk;
        GetSpeeds(&t_memclk, &nvclk, card_number, debug);
        printf("Keeping current core clock:\t%0.3f MHz\n", nvclk);
    }

    
    printf("Requested memory speed: \t%0.3f MHz\n", memclk);
    printf("Requested core speed: \t\t%0.3f MHz\n", nvclk);    


    ChangeSpeeds(memclk, nvclk, card_number, debug);
    GetSpeeds(&memclk, &nvclk, card_number, 0);

    printf("\n%s\n", nv_info->device_string);
    printf("New memory speed:\t\t%0.3f MHz\n", memclk);
    printf("New core speed:\t\t\t%0.3f MHz\n", nvclk);
    printf("\n");

    
    return 0;
}
