#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

int card_number = 0;
int debug = 0;
float memclk = 0;
float nvclk = 0;

GtkObject *value_mem;
GtkObject *value_core;


void update_core()
{
    gchar *value;
    GtkWidget *entry_core = lookup_widget(window_nvclock, "entry_core");

    value = g_strdup_printf("%d",  (gint)GTK_ADJUSTMENT(value_core)->value);
    gtk_entry_set_text(GTK_ENTRY(entry_core), value);
    nvclk = GTK_ADJUSTMENT(value_core)->value;
    g_free(value);

}

void update_mem()
{
    gchar *value;
    GtkWidget *entry_mem = lookup_widget(window_nvclock, "entry_mem");
    value = g_strdup_printf("%d",  (gint)GTK_ADJUSTMENT(value_mem)->value);
    gtk_entry_set_text(GTK_ENTRY(entry_mem), value);
    memclk = GTK_ADJUSTMENT(value_mem)->value;
    g_free(value);
}

void fill_card_combo()
{
    int i;
    const struct card_info *nv_info;
    GList *items = NULL;
    GtkWidget *combo_card  = lookup_widget(window_nvclock, "combo_card");
    

    for(i = 0; i <= total_cards; i++)
    {
	gchar *temp;
	nv_info = GetCardInfo(i);
    
	temp = g_strdup_printf("%d: %s", i+1, nv_info->device_string);

	items = g_list_append(items, temp);
    }

    gtk_combo_set_popdown_strings(GTK_COMBO(combo_card), items);
    
    g_list_free(items);
}

/* This function updates the min/max values of the sliders, the speeds and more on the gui. */
void update_info()
{
    gchar *text;
    const struct card_info *nv_info = GetCardInfo(card_number);

    GtkWidget *entry_core = lookup_widget(window_nvclock, "entry_core");
    GtkWidget *entry_mem = lookup_widget(window_nvclock, "entry_mem");

    GetSpeeds(&memclk, &nvclk, card_number, debug);

    text = g_strdup_printf("%0.3f", memclk);
    (gint)GTK_ADJUSTMENT(value_mem)->lower = nv_info->memclk_min;
    (gint)GTK_ADJUSTMENT(value_mem)->upper = nv_info->memclk_max;
    (gint)GTK_ADJUSTMENT(value_mem)->value = (memclk);
    gtk_adjustment_set_value(GTK_ADJUSTMENT(value_mem), memclk);
    gtk_entry_set_text(GTK_ENTRY(entry_mem), text);
    g_free(text);
	
    text = g_strdup_printf("%0.3f", nvclk);
    (gint)GTK_ADJUSTMENT(value_core)->lower = nv_info->nvclk_min;
    (gint)GTK_ADJUSTMENT(value_core)->upper = nv_info->nvclk_max;
    (gint)GTK_ADJUSTMENT(value_core)->value = (nvclk);
    gtk_adjustment_set_value(GTK_ADJUSTMENT(value_core), nvclk);
    gtk_entry_set_text(GTK_ENTRY(entry_core), text);


    g_free(text);
}

/* This function sets all card info on the gui. */
void update_card_info()
{
    gchar *memsize, *memtype, *fwstatus, *sbastatus, *agprate;
    int size;
    const struct card_info *nv_info = GetCardInfo(card_number);

    GtkWidget *label_gpu_text = lookup_widget(window_nvclock, "label_gpu_text");
    GtkWidget *label_bustype_text = lookup_widget(window_nvclock, "label_bustype_text");
    GtkWidget *label_memsize_text = lookup_widget(window_nvclock, "label_memsize_text");
    GtkWidget *label_memtype_text = lookup_widget(window_nvclock, "label_memtype_text");
    GtkWidget *label_agpstatus_text = lookup_widget(window_nvclock, "label_agpstatus_text");
    GtkWidget *label_fwstatus_text = lookup_widget(window_nvclock, "label_fwstatus_text");
    GtkWidget *label_sbastatus_text = lookup_widget(window_nvclock, "label_sbastatus_text");
    GtkWidget *label_agprate_text = lookup_widget(window_nvclock, "label_agprate_text");
    GtkWidget *label_agprates_text = lookup_widget(window_nvclock, "label_agprates_text");
    
    gtk_label_set_text(GTK_LABEL(label_gpu_text), nv_info->device_string);
    gtk_label_set_text(GTK_LABEL(label_bustype_text), nv_info->bus_type);

    memsize = g_strdup_printf("%d MB", nv_info->memory_size);
    gtk_label_set_text(GTK_LABEL(label_memsize_text), memsize);

    memtype = g_strdup_printf("%d bit %s", nv_info->memory_width, nv_info->memory_type);
    gtk_label_set_text(GTK_LABEL(label_memtype_text), memtype);

    gtk_label_set_text(GTK_LABEL(label_agpstatus_text), nv_info->agp_status);

    fwstatus = g_strdup_printf("%s, %s", nv_info->fw_support, nv_info->fw_status);
    gtk_label_set_text(GTK_LABEL(label_fwstatus_text), fwstatus);

    sbastatus = g_strdup_printf("%s, %s", nv_info->sba_support, nv_info->sba_status);
    gtk_label_set_text(GTK_LABEL(label_sbastatus_text), sbastatus);
    
    /* Check if the agp_rate isn't 0, if it is 0 the card is a pci card. */
    if(nv_info->agp_rate == 0)
    {
	gtk_label_set_text(GTK_LABEL(label_agprate_text), "-");
    }

    else
    {
	agprate = g_strdup_printf("%dX", nv_info->agp_rate);
	gtk_label_set_text(GTK_LABEL(label_agprate_text), agprate);
	g_free(agprate);
    }
    
    gtk_label_set_text(GTK_LABEL(label_agprates_text), nv_info->agp_support_rate);


    g_free(memsize);
    g_free(memtype);
}

/* This function updates the speeds on the gui. */
void update(gfloat memclk, gfloat nvclk)
{
    gchar *text;
    GtkWidget *entry_core = lookup_widget(window_nvclock, "entry_core");
    GtkWidget *entry_mem = lookup_widget(window_nvclock, "entry_mem");
	
    text = g_strdup_printf("%0.3f", memclk);
    gtk_adjustment_set_value(GTK_ADJUSTMENT(value_mem), memclk);
    gtk_entry_set_text(GTK_ENTRY(entry_mem), text);
    g_free(text);
	
    text = g_strdup_printf("%0.3f", nvclk);
    gtk_adjustment_set_value(GTK_ADJUSTMENT(value_core), nvclk);
    gtk_entry_set_text(GTK_ENTRY(entry_core), text);
    g_free(text);
}

/* This function overclocks the card and updates the speeds on the gui. */
void change_speeds(GtkButton *button, gpointer data)
{
    ChangeSpeeds(memclk, nvclk, card_number, debug);
    GetSpeeds(&memclk, &nvclk, card_number, debug);
    update(memclk, nvclk);
}

/* This function sets the debug flag. */
void debug_info(GtkToggleButton *button, gpointer user_data)
{
    debug = gtk_toggle_button_get_active(button);
}

gboolean nvclock_exit(GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
    gtk_main_quit();
}

/* This function is used when another card is selected using the combo box. */
void change_cards(GtkEditable *editable, gpointer user_data)
{
    char *text;
    GtkWidget *combo = lookup_widget(window_nvclock, "combo_card");
    text = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo)->entry));

    /*  Use the following line as a workaround. This function is called when the value of the combo_entry changes, but
	but that has one little problem. When selecting something else in the combo box the signal is sent out twice.
	One time to empty the entry and another time to fill it with the new stuff. */

    if(atoi(text) == 0)
	return; /* Do nothing. */

    /* The first char of text is the the card number. Where number is between 1 and 4. This way might be a bit hacky*/
    card_number = atoi(text) - 1;

    /* Update the min/max values of the sliders, the speeds on the gui ... */
    update_info();
    
    /* Update all info about the card: AGP, chipname, bustype ... */
    update_card_info();
}

void slider_core_realize()
{
    GtkWidget *slider_core = lookup_widget(window_nvclock, "slider_core");
    
    value_core = gtk_adjustment_new(0, 1, 1000, 1, 1, 1);
    gtk_signal_connect(GTK_OBJECT(value_core), "value_changed", GTK_SIGNAL_FUNC(update_core), NULL);
    gtk_range_set_adjustment(GTK_RANGE(slider_core), GTK_ADJUSTMENT(value_core));
}

void slider_mem_realize()
{
    GtkWidget *slider_mem = lookup_widget(window_nvclock, "slider_mem");
    
    value_mem = gtk_adjustment_new(0, 1, 1000, 1, 1, 1);
    gtk_signal_connect(GTK_OBJECT(value_mem), "value_changed", GTK_SIGNAL_FUNC(update_mem), NULL);
    gtk_range_set_adjustment(GTK_RANGE(slider_mem), GTK_ADJUSTMENT(value_mem));
}
