/* NVClock 0.6.2 - Linux overclocker for NVIDIA cards
 *
 * site: http://nvclock.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#define MAX_CARDS 4

#include <unistd.h>

struct card_info {
    char *device_string; /* Name of the card */
    int supported;
    int device_id;
    unsigned int reg_address;
    
    /* Overclock range of speeds */
    int nvclk_min; 
    int nvclk_max; 
    int memclk_min; 
    int memclk_max; 

    /* Memory info */
    char *memory_type; /* Memory type: SDR/DDR */
    int memory_width; /* Memory width 64bit or 128bit */
    int memory_size; /* Amount of memory between 4 and 128 MB */

    /* AGP info */
    char *bus_type; /* Bus type: AGP/PCI */
    char *agp_support_rate; /* Supported AGP rates */
    char *fw_support; /* Tells if FW is supported/unsupported */
    char *sba_support; /* Tells if SBA is supported/unsupported */
    int agp_rate; /* Current AGP rate: 1, 2 or 4 */
    char *agp_status; /* Current AGP status: Enabled/Disabled */
    char *fw_status; /* Current FW status: Enabled/Disabled */
    char *sba_status; /* Current SBA status: Enabled/Disabled */
};


#ifdef __cplusplus
extern "C" {
#endif

int FindAllCards();
int ChangeSpeeds(float memclk, float nvclk, int card_number, int debug);
int GetSpeeds(float *memclk, float *nvclk, int card_number, int debug);
const struct card_info *GetCardInfo(int card_number);


#ifdef __cplusplus    
};
#endif
