/* NVClock 0.6.2 - Linux overclocker for NVIDIA cards
 *
 * site: http://nvclock.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#define MAX_CARDS 4

#include <sys/mman.h> 
#include <fcntl.h>
#include <stdio.h>
#include <sys/ioctl.h>
#include <errno.h>

struct pci_ids {
    int   id;
    char *name;
    int   mem_min;
    int   mem_max;
    int   nv_min;
    int   nv_max;
    int   supported;
};

struct card {
    int device_id;
    unsigned int reg_address;
};

typedef struct {
    volatile unsigned int *PFB;
    volatile unsigned int *PBUS;
    volatile unsigned int *PMC;
    volatile unsigned int *PRAMDAC;
    volatile unsigned int *PEXTDEV;
} riva_hw;

#ifdef __cplusplus
extern "C" {
#endif

int CheckDriver();
int CheckDeviceId(int device_id);
extern struct card card[MAX_CARDS];
extern int nv_driver;

int openDevMem (int number);
void *mapDevMem (int fd, unsigned long Base, unsigned long Size);
void unmapDevMem (unsigned long Base, unsigned long Size);

#ifdef __cplusplus    
};
#endif
