/* NVClock 0.6.2 - Linux overclocker for NVIDIA cards
 *
 * site: http://nvclock.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "backend.h"

struct card card[MAX_CARDS];
int nv_driver = 0;

int FindAllCards_proc();

/* Check if we are using the closed source Nvidia drivers */
int CheckDriver()
{
    FILE *proc;
    char buffer[80];
    
    proc = fopen("/proc/modules", "r");
    
    if(proc  == NULL) 
    {
	printf("Can't open /proc/modules\n");
    }

    else
    {
        while(fgets(buffer, 80, proc) != NULL)
	{	
	    if((strstr(buffer, "NVdriver") != 0))
	    {
		return 1;
	    }

	    /* Needed for driver version 1.0-4xxx */
	    if((strstr(buffer, "nvidia") != 0))
	    {
		return 2;
	    }
	}	
    }
    fclose(proc);

    return 0;
}

/* Detect all nVidia cards using ioctl's or using /proc when the 
*  closed source nVidia drivers aren't installed/loaded.
*/
int FindAllCards()
{
    nv_driver = CheckDriver();

    /* Check if the nvidia drivers are loaded or if the user is root */
    if(nv_driver || (getuid() == 0 && geteuid() == 0))
    {
	return FindAllCards_proc();
    }

    /* Return codes:
    *  >= 0 nvclock found 1 or more nvidia videocards
    *  -1 nvclock couldn't find any nvidia cards
    *  -2 the NVdriver isn't loaded and the user isn't root.
    *     Only root users can have access to the card in this case since we
    *     we need access to /dev/mem. */
    
    return -2;
}

/* Detect all nvidia cards using /proc/bus/pci/devices. This only works on Linux. */
int FindAllCards_proc()
{
    int dev, dum, reg_addr, i = -1;
    char buf[0x1000];

    FILE *proc;

    proc = fopen("/proc/bus/pci/devices", "r");
    if (!proc) return 0;


    while (fgets(buf, sizeof(buf)-1, proc)) 
    {
	if (sscanf(buf,"%x %x %x %x",&dum, &dev, &dum, &reg_addr) != 4) continue;

	if( (dev>>16) == 0x10de)
        {
	    /* Check if the nVidia card is in our device list. If not we don't assume it is a videocard. */
	    if(CheckDeviceId((0x0000ffff & dev)) == 1)
	    {
		i++;
		card[i].device_id = (0x0000ffff & dev);

		/* Thanks to all different driver version this is needed now.
		*  When nv_driver > 1 the nvidia kernel module is loaded. 
		*  For driver versions < 1.0-40xx the register offset could be set to 0.
		*  Thanks to a rewritten kernel module in 1.0-40xx the register offset needs
		*  to be set again to the real offset. */
		switch(nv_driver)
		{
		    case 0:
    			card[i].reg_address = reg_addr;
			break;
		    case 1:
			card[i].reg_address = 0;
			break;
		    case 2:
    			card[i].reg_address = reg_addr;
		    	break;	    		    
		}
	    }
    	}
    }

    fclose(proc);


    return(i);
}
