#!/bin/sh

name="mozilla-firebird"
title="Mozilla Firebird"
package="mozilla-firebird"
version="0.6"
build="1.2"
noarch="n"
build_info="Standard build."

info="Mozilla web browser."
desc="The Mozilla Firebird project is a redesign of Mozilla's
browser component, written using the XUL user interface
language and designed to be cross-platform."
category="net/client/www"
environment="x11"
contact="$name@packages.packware.one.pl"
vendor="The Packware Project"
vendor_id="pw"

requires=""
obsoletes=""
conflicts=""

docs_source="LEGAL,LICENSE,README.txt"
docs_cwd=""

strip_bin="y"
reset_own="y"
reset_dir="y"
reset_fil="y"
delete_cat="y"

. /usr/src/tgz/lib/builder.defs

add_source http://komodo.mozilla.org/pub/firebird/releases/$version/MozillaFirebird-$version-source.tar.bz2 mozilla

export MOZ_PHOENIX=1

configure_option --prefix=/usr
configure_option --without-system-nspr
configure_option --with-system-jpeg
configure_option --with-system-zlib
configure_option --with-system-png
configure_option --without-mng
configure_option --enable-crypto
configure_option --disable-tests
configure_option --disable-debug
configure_option --disable-mailnews
configure_option --disable-composer
configure_option --enable-optimize=-O2
configure_option --disable-ldap
configure_option --disable-mailnews
configure_option --enable-extensions=default,-inspector,-irc,-venkman,-content-packs,-help
configure_option --enable-plaintext-editor-only
configure_option --disable-installer
[ "$slackver_maj" -ge "9" ] && configure_option --enable-xft

install_option DESTDIR=$pkg_main

parent_package="$package"
write_info main

cd $src1

do_configure
do_make
do_install

make_docs

make_package main

clean_up

# $Log: mozilla-firebird.builder,v $
# Revision 1.2  2003/05/17 21:51:17  swiergot
# - Enable xft only if we're on Slackware 9 or later.
#
# Revision 1.1  2003/05/17 21:33:27  swiergot
# - Initial release.
# - Version 0.6.
#
