#!/bin/sh

name="mod_python"
title="Mod_python"
package="mod_python"
version="3.0.3"
build="1.1"
noarch="n"
build_info="Standard build."

info="An Apache module that interprets Python."
desc="Mod_python is an Apache module that embeds the Python interpreter
within the server. With mod_python you can write web-based applications
in Python that will run many times faster than traditional CGI and will
have access to advanced features such as ability to retain database
connections and other data between hits and access to Apache internals."
category=""
environment=""
requires="httpd"
obsoletes=""
conflicts=""

docs_source="CREDITS,COPYRIGHT,NEWS,README"
docs_cwd=""

strip_bin="y"
reset_own="y"
reset_dir="y"
reset_fil="y"
delete_cat="y"

. /usr/src/tgz/lib/builder.defs

add_source http://sunsite.icm.edu.pl/pub/www/apache/dist/httpd/modpython/$name-$version.tgz

apply_patch mod_python-destdir.pw.patch

configure_option --prefix=/usr
configure_option --with-apxs=/usr/sbin/apxs

install_option DESTDIR=$pkg_main

parent_package="$package"
write_info main

cd $src1

do_configure
do_make
do_install

make_docs

make_package main

clean_up

# $Log: mod_python.builder,v $
# Revision 1.6  2003/05/28 20:42:15  stoodi
# - version 3.0.3, build 0
#
# Revision 1.5  2003/05/28 20:25:19  stoodi
# - version 3.0.5, build 0
#
# Revision 1.4  2002/12/31 14:48:51  stoodi
# - Build 1.
#
# Revision 1.3  2002/12/30 21:08:16  stoodi
# - changed documentation files.
#
# Revision 1.2  2002/12/30 20:24:30  swiergot
# - Added a destdir patch to allow use other parent install directory.
# - Fixed info and build_info.
# - Cosmetics.
#
