#!/bin/sh

name="mc"
title="Midnight Commander"
package="mc"
version="4.6.0"
build="2.1"
noarch="n"
build_info="Standard build."

info="Unix file manager and shell."
desc="GNU Midnight Commander is a text-mode full-screen file manager.
It uses a two panel interface and a subshell for command
execution. It includes an internal editor with syntax
highlighting and an internal viewer with support for binary
files. Also included is Virtual Filesystem (VFS), that allows
files on remote systems (e.g. FTP servers) and files inside
archives to be manipulated like real files."
category="system/shell"
environment="console/slang"
contact="$name@packages.packware.one.pl"
vendor="The Packware Project"
vendor_id="pw"

requires=""
obsoletes=""
conflicts=""

docs_source="ABOUT-NLS,AUTHORS,COPYING,FAQ,INSTALL,MAINTAINERS,NEWS,README,doc/DEVEL"
docs_cwd=""

strip_bin="y"
reset_own="y"
reset_dir="y"
reset_fil="y"
delete_cat="y"

. /usr/src/tgz/lib/builder.defs

add_source ftp://ftp.ibiblio.org/pub/Linux/utils/file/managers/mc/$name-`echo $version | tr _ -`.tar.gz

apply_patch dotdot_in_rootdir 1
apply_patch dotdot_in_rootdir_pl_po 1

apply_patch src_option_c_PANEL_OPTIONS_bug.diff 1
apply_patch X_func_dynload.diff 1
apply_patch patch-4_6_0-exe-first.diff 1

configure_option --prefix=/usr
configure_option --sysconfdir=/etc
configure_option --localstatedir=/var
configure_option --enable-charset
configure_option --with-gpm-mouse
configure_option --with-ext2undel
configure_option --with-x=no
configure_option --with-vfs
configure_option --with-screen=mcslang

install_option DESTDIR=$pkg_main

parent_package="$package"
write_info main

cd $src1

do_configure
do_make
do_install

make_docs

make_package main

clean_up

# $Log: mc.builder,v $
# Revision 1.18  2003/02/10 19:53:47  swiergot
# - Added X_func_dynload.diff patch that makes it possible to dynamically
#   load X11 stuff on demand.
# - Added patch-4_6_0-exe-first.diff patch that makes it possible to place
#   exe files first just after directories in a panel.
# - Added src_option_c_PANEL_OPTIONS_bug.diff that fixes a small bug.
# - Note: this combination of patches hasn't been tested yet.
#
# Revision 1.17  2003/02/05 22:13:05  swiergot
# - Build 1.
#
# Revision 1.16  2003/02/05 19:48:10  swiergot
# - Version 4.6.0.
#
# Revision 1.15  2003/01/31 21:53:42  swiergot
# - Build 1.
#
# Revision 1.14  2003/01/31 15:54:56  swiergot
# - Fixed dotdot_in_rootdir patch.
#
# Revision 1.13  2003/01/30 16:18:31  swiergot
# - Fixed dotdot_in_rootdir patch.
# - Splited dotdot_in_rootdir_po patch into two patches - for pot file and for
#   pl.po file.
#
# Revision 1.12  2003/01/30 15:25:14  swiergot
# - Fixed dotdot_in_rootdir patch.
#
# Revision 1.11  2003/01/28 21:24:04  swiergot
# - Fixed dotdot_in_rootdir patch.
#
# Revision 1.10  2003/01/28 21:18:09  swiergot
# - Removed po diffs from dotdot_in_rootdir patch.
#
# Revision 1.9  2003/01/28 20:43:07  swiergot
# - Fixed dotdot_in_rootdir patch.
#
# Revision 1.8  2003/01/28 20:11:51  swiergot
# - Fixed dotdot_in_rootdir patch.
#
# Revision 1.7  2003/01/28 18:47:59  swiergot
# - Fixed a stupid typo in dotdot_in_rootdir patch.
#
# Revision 1.6  2003/01/28 18:01:24  swiergot
# - Splitted out diffs relevant to po files from dotdot_in_rootdir patch.
# - Added dotdot_in_rootdir_po patch but disabled for now as one of
#   translation files causes compile-time problems.
#
# Revision 1.5  2003/01/28 17:51:11  swiergot
# - Renamed dotdot_in_root_dir patch to dotdot_in_rootdir.
# - Improved dotdot_in_rootdir patch. Now it is possible to set a proper
#   configuration option to tell mc whether it should show .. in /.
#
# Revision 1.4  2003/01/28 17:28:36  swiergot
# *** empty log message ***
#
# Revision 1.3  2003/01/27 20:23:21  swiergot
# - Changed environment to console/slang.
#
# Revision 1.2  2003/01/27 20:00:22  swiergot
# - Inserted an underscore before 'pre' in version.
# - Translate an underscore to a dash from version in add_source.
#
# Revision 1.1  2003/01/27 19:28:04  swiergot
# - Initial release.
# - Version 4.6.0pre3.
# - Note on dotdot_in_root_dir patch - since 4.6.0pre3 .. is no longer shown
#   in / directory. I don't like this new behavior so the patch restores the
#   old one.
#
