#!/bin/sh

name="irda-utils"
title="irda-utils"
package="irda-utils"
version="0.9.15"
build="1.4"
noarch="n"
build_info="Standard build."

info="Utilities for infrared communication between devices."
desc="IrDA(TM) (Infrared Data Association) is an industry standard
for wireless, infrared communication between devices. IrDA
speeds range from 9600 bps to 4 Mbps, and IrDA can be used
by many modern devices including laptops, LAN adapters, PDAs,
printers, and mobile phones.
The Linux-IrDA project is a GPL'd implementation, written from
scratch, of the IrDA protocols. Supported IrDA protocols include
IrLAP, IrLMP, IrIAP, IrTTP, IrLPT, IrLAN, IrCOMM and IrOBEX.
The irda-utils package contains a collection of programs that
enable the use of IrDA protocols. Most IrDA features are
implemented in the kernel, so IrDA support must be enabled in
the kernel before any IrDA tools or programs can be used. Some
configuration outside the kernel is required, however, and some
IrDA features, like IrOBEX, are actually implemented outside the
kernel."
category="system/communication"
environment="console/text"
contact="$name@packages.packware.one.pl"
vendor="The Packware Project"
vendor_id="pw"

requires=""
obsoletes=""
conflicts=""

docs_source="README"
docs_cwd=""

strip_bin="y"
reset_own="y"
reset_dir="y"
reset_fil="y"
delete_cat="y"

. /usr/src/tgz/lib/builder.defs

add_source http://irda.sourceforge.net/ftp/irda-utils/$name-$version.tar.gz

install_option ROOT=$pkg_main 
install_option DESTDIR=$pkg_main
install_option RPM_BUILD_ROOT=$pkg_main

parent_package="$package"
write_info main

cd $src1

do_make

mkdir -p $pkg_main/usr/{bin,sbin}

do_install

make_docs

for dir in irattach irdadump irdaping tekram; do
    cp $dir/README $docdir/README.$dir
done

make_package main

clean_up

# $Log: irda-utils.builder,v $
# Revision 1.4  2003/02/01 15:58:27  swiergot
# - Cleanups.
#
# Revision 1.3  2003/02/01 13:53:48  swiergot
# - Fixed source URL.
#
# Revision 1.2  2003/02/01 13:30:48  swiergot
# - Fixed source URL.
# - Many cleanups.
#
