#!/bin/sh

name="bugzilla"
title="BugZilla"
package="bugzilla"
version="2.16.2"
build="0"
noarch="y"
build_info="Standard build."

info="A powerful bugtracking system." 
desc="Bugzilla is the leading open-source/free software bug tracking
system, with high-profile installations at mozilla.org, GNOME,
Red Hat, and NASA, among others. It features a comprehensive
set of fields, attachment management, inter-bug dependencies,
email notification of changes, a powerful query interface,
reporting, and Web, XML, email, and console interfaces. It
can be managed entirely using a Web-based UI. The user UI is
customizable using templates."
category="development/bugtrack"
environment="www"
contact="$name@packages.packware.one.pl"
vendor="The Packware Project"
vendor_id="pw"

requires=""
obsoletes=""
conflicts=""

docs_source="README,UPGRADING,docs/rel_notes.txt,contrib"
docs_cwd=""

strip_bin="y"
reset_own="y"
reset_dir="y"
reset_fil="y"
delete_cat="y"

. /usr/src/tgz/lib/builder.defs

add_source ftp://ftp.mozilla.org/pub/webtools/$name-$version.tar.gz

parent_package="$package"
write_info main

cd $src1

msg_installing

for i in *.gif *.pm *.pl *.jpg *.cgi *.html *.dtd *.js processmail robots.txt syncshadowdb ; do

    copy $i $pkg_main/var/www/htdocs/bugzilla

done

for i in $pkg_main/var/www/htdocs/bugzilla/{*.pl,*.pm,*.cgi,processmail,syncshadowdb} ; do

    replace_regexp $i /usr/bonsaitools/ /usr/
    replace_regexp $i /usr/lib/sendmail /usr/sbin/sendmail

done

cp -R css $pkg_main/var/www/htdocs/bugzilla
cp -R template $pkg_main/var/www/htdocs/bugzilla

make_docs

mkdir -p $pkg_main/usr/doc/$name-$version/html
cp -R $src1/docs/images $pkg_main/usr/doc/$name-$version/html

for i in $src1/docs/html/*.html; do

    sed 's}\.\./images/}images/}g' $i > $pkg_main/usr/doc/$name-$version/html/`basename $i`

done

find $pkg_main \( -name CVS -o -name .cvsignore \) -exec rm -rf {} \; > /dev/null 2>&1

make_package main

clean_up

# $Log: bugzilla.builder,v $
# Revision 1.11  2003/01/03 15:28:41  swiergot
# - Version 2.16.2.
# - Fixed title that was accidentally "Gabber" :-)
#
# Revision 1.10  2003/01/02 19:34:42  swiergot
# - Fix paths to sendmail in all files according to Slackware conditions.
#
# Revision 1.9  2003/01/02 15:32:03  swiergot
# - Changed noarch to y.
#
# Revision 1.8  2003/01/02 15:30:37  swiergot
# - Reversed last change as the errors were an obvious consequence of what we
#   were doing. This time we redirect whole output to /dev/null to get rid of
#   them.
#
# Revision 1.7  2003/01/02 14:18:16  swiergot
# - Debug removing CVS control files and directories.
#
# Revision 1.6  2003/01/02 14:02:05  swiergot
# - Fixed removing CVS control files and directories.
#
# Revision 1.5  2003/01/02 13:47:00  swiergot
# - Remove CVS control files and directories from the package.
#
# Revision 1.4  2003/01/02 13:00:47  swiergot
# - Fixed a path to put processed HTML files.
#
# Revision 1.3  2003/01/02 12:54:25  swiergot
# - Fixed a path to images in the source.
#
# Revision 1.2  2003/01/02 12:41:48  swiergot
# - Fixed source path of HTML docs.
#
# Revision 1.1  2003/01/02 12:15:34  swiergot
# - Initial release.
# - Version 2.16.1.
#
