#!/bin/sh

name="vim"
title="Vi IMproved"
package="vim"
bver="001"
pver="014"
version="6.2.$pver"
ctags="5.5"
build="1"
noarch="n"
build_info="Standard build."

info="A popular vi clone with many improvements."
desc="Vim is an almost fully-compatible version of the Unix
editor Vi. Many new features have been added including
multi-level undo, syntax highlighting, commandline
history, online help, filename completion, and block
operations. It is descended from the vi clone 'stevie'
and runs on many systems, including Unix, MS Windows,
OS/2, Macintosh, VMS, and Amiga."
category="editor/text"
environment="console/text"
contact="$name@packages.packware.one.pl"
vendor="The Packware Project"
vendor_id="pw"

requires=""
obsoletes=""
conflicts=""

docs_source="README.txt"
docs_cwd=""

strip_bin="y"
reset_own="y"
reset_dir="y"
reset_fil="y"
delete_cat="y"

. /usr/src/tgz/lib/builder.defs

vver=`echo $version | cut -d '.' -f 1,2`
sver=`echo $vver | tr -d '.'`

add_source ftp://ftp.vim.org/pub/vim/unix/$name-$vver.tar.bz2 $name$sver
add_source ftp://ftp.vim.org/pub/vim/extra/$name-$vver-lang.tar.gz $name$sver
add_source http://cesnet.dl.sourceforge.net/sourceforge/ctags/ctags-$ctags.tar.gz

#for i in 1-100 101-200 201-300 301-400; do
#	add_source http://www.intersec.pl/~swiergot/vim/$vver.$i.bz2 .
#	( cd $src1
#	bzcat $src_pkg/$vver.$i.bz2 | patch -p0 --batch > /dev/null 2>&1 )
#done

while [ $bver -le $pver ]; do
	add_source http://www.intersec.pl/~swiergot/vim/$vver.`printf "%03d" $bver`.bz2 .
	( cd $src1
	bzcat $src_pkg/$vver.`printf "%03d" $bver`.bz2 | patch -p0 --batch > /dev/null 2>&1 )
	bver=`expr $bver + 1`
done

configure_option --prefix=/usr
configure_option --without-x
configure_option --disable-gui
configure_option --with-features=big

install_option DESTDIR=$pkg_main

parent_package="$package"
write_info main

cd $src3

do_configure --prefix=/usr
do_make
do_install prefix=$pkg_main/usr

mkdir -p $pkg_main/usr/doc/ctags-$ctags
cp COPYING EXTENDING.html FAQ INSTALL NEWS README $pkg_main/usr/doc/ctags-$ctags

cd $src1

do_configure
do_make
do_install

( cd $pkg_main/usr/bin
ln -s vim eview
ln -s vim evim )

( cd $pkg_main/usr/man/man1
rm -f ex.1
rm -f rvim.1
rm -f view.1
rm -f rview.1
rm -f etags.1
echo ".so man1/vim.1" > ex.1
echo ".so man1/vim.1" > rview.1
echo ".so man1/vim.1" > rvim.1
echo ".so man1/vim.1" > view.1 )

make_docs

( cd $pkg_main/usr/doc/$name-$version
ln -s /usr/share/vim/vim$sver doc )

make_package main

clean_up

# $Log: vim.builder,v $
# Revision 1.9  2003/06/17 18:57:03  swiergot
# - Build 1.
#
# Revision 1.8  2003/06/17 18:48:50  swiergot
# - Force building.
#
# Revision 1.7  2003/06/17 18:44:18  swiergot
# - Vim 6.2, patchlevel 014.
# - Fixed .builder to handle all possible patchlevels.
#
# Revision 1.6  2003/05/11 19:08:57  swiergot
# - Our builder can't handle vim version so build 2 is required.
#
# Revision 1.5  2003/05/11 17:24:29  swiergot
# - Build 1.
#
# Revision 1.4  2003/05/11 17:16:58  swiergot
# - Patchlevel 474.
#
# Revision 1.3  2003/04/15 16:57:43  swiergot
# - Build 1.
#
# Revision 1.2  2003/04/15 16:48:18  swiergot
# - Fixed source URL.
#
# Revision 1.1  2003/04/15 16:42:12  swiergot
# - Initial release.
# - Version 6.1, patch 464.
#
