/* Linux Commander
 * Copyright (C) 2000 Per Holmng.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "linuxcmd.h"

GtkWidget *toolbar_new_window;
GtkWidget *entry1,*entry2,*entry3,*entry4;
gint toolbar_selectedrow = -1;

void cb_toolbar_clist_select_row(GtkWidget *clist, gint row,gint column,GdkEvent *event, FileList *list);
void cb_toolbar_clist_unselect_row(GtkWidget *clist, gint row,gint column,GdkEvent *event, FileList *list);
void get_toolbar(GtkWidget *clist);
void toolbar_remove(GtkWidget *wid, GtkWidget *clist);
void toolbar_add(GtkWidget *wid, GtkWidget *clist);
void toolbar_edit(GtkWidget *wid, GtkWidget *clist);
void cb_toolbar_dblclick(GtkWidget *clist, GdkEventButton *event,FileList *list);
void cb_toolbar_click(GtkWidget *wid, gchar *cmd);
void cb_toolbar_new_ok(GtkWidget *wid, GtkWidget *clist);
void cb_toolbar_new_cancel(GtkWidget *wid, GtkWidget *clist);
void create_toolbar_new_dialog(gchar *title,gchar *txt1,gchar *txt2,gchar *txt3,gchar *txt4,GtkWidget *clist);
void write_toolbar(GtkWidget *clist);

void cb_toolbar_clist_select_row(GtkWidget *clist, gint row,gint column,GdkEvent *event, FileList *list)
{
    toolbar_selectedrow = row;
	if (event)
	{
		if (event->type == GDK_2BUTTON_PRESS)
		{
			toolbar_edit(NULL,clist);
		}
	}
}

void cb_toolbar_new_ok(GtkWidget *wid, GtkWidget *clist)
{
    GdkBitmap *mask;
    GdkPixmap *icon;
    gchar *buf[5];
    gint row;
	gint rownr; 
	
    buf[0] = "";
	buf[1] = gtk_entry_get_text(GTK_ENTRY(entry1));
	buf[2] = gtk_entry_get_text(GTK_ENTRY(entry2));
	buf[3] = gtk_entry_get_text(GTK_ENTRY(entry3));
    buf[4] = gtk_entry_get_text(GTK_ENTRY(entry4));
	
    icon = gdk_pixmap_create_from_xpm (app.main_window->window,&mask,&app.main_window->style->white,buf[4]);
    
	if (toolbar_selectedrow == -1)
	{
		rownr = gtk_clist_append(GTK_CLIST(clist),buf);
        gtk_clist_set_pixmap(GTK_CLIST(clist),rownr,0,icon,mask);
	}
	else
	{
        row = toolbar_selectedrow;
		gtk_clist_remove(GTK_CLIST(clist),toolbar_selectedrow);
		gtk_clist_insert(GTK_CLIST(clist),row,buf);
        gtk_clist_set_pixmap(GTK_CLIST(clist),row,0,icon,mask);
	}
	gtk_grab_remove(toolbar_new_window);
	gtk_widget_destroy(toolbar_new_window);
	gtk_main_quit();
	write_toolbar(clist);

}

void cb_toolbar_browse_file()
{
    gchar *buf;
    file_sel("Select filename","",&buf);
    gtk_main();
    if (buf)
        gtk_entry_set_text(GTK_ENTRY(entry4),buf);
}

void cb_toolbar_new_cancel(GtkWidget *wid, GtkWidget *clist)
{
    gtk_grab_remove(toolbar_new_window);
	gtk_widget_destroy(toolbar_new_window);
	gtk_main_quit();
}

void cb_toolbar_clist_unselect_row(GtkWidget *clist, gint row,gint column,GdkEvent *event, FileList *list)
{
    toolbar_selectedrow = -1;
	if (event)
	{
		if (event->type == GDK_2BUTTON_PRESS)
		{
			toolbar_edit(NULL,clist);
		}
	}
}

void write_toolbar(GtkWidget *clist)
{
	gint a;
	FILE *fp;
	gchar *tooltip,*name,*command,*icon;
	gint def;
	
	if ((fp = fopen(get_toolbar_filename(),"w")))
	{
		for (a = 0; a < GTK_CLIST(clist)->rows; a++)
		{
			gtk_clist_get_text(GTK_CLIST(clist),a,1,&name);
			gtk_clist_get_text(GTK_CLIST(clist),a,2,&tooltip);
			gtk_clist_get_text(GTK_CLIST(clist),a,3,&command);
            gtk_clist_get_text(GTK_CLIST(clist),a,4,&icon);
			def = (gint)gtk_clist_get_row_data(GTK_CLIST(clist),a);
    		fprintf(fp,"%s;%s;%s;%s\n",name,tooltip,command,icon);
		}
		gtk_clist_set_column_width(GTK_CLIST(clist),0,gtk_clist_optimal_column_width(GTK_CLIST(clist),0));
		gtk_clist_set_column_width(GTK_CLIST(clist),1,gtk_clist_optimal_column_width(GTK_CLIST(clist),1));
        gtk_clist_set_column_width(GTK_CLIST(clist),2,gtk_clist_optimal_column_width(GTK_CLIST(clist),2));
        gtk_clist_set_column_width(GTK_CLIST(clist),3,gtk_clist_optimal_column_width(GTK_CLIST(clist),3));
		fclose(fp);
	}
}


void get_toolbar(GtkWidget *clist)
{
    FILE *fp;
	gchar buf[256];
	gchar *row[5];
	gchar *strip,*def;
	gint rownr = 0;
    GdkPixmap *icon;
    GdkBitmap *mask;
	gint tmp;
    
	gtk_clist_freeze(GTK_CLIST(clist));
	if ((fp = fopen(get_toolbar_filename(),"r")))
	{
		while (fgets(buf,256,fp))
		{
			if ((strip = strchr(buf,'\n')))
				*strip = 0;
            row[0] = "";
			row[1] = strtok(buf,";");
			row[2] = strtok(NULL,";");
			row[3] = strtok(NULL,";");
            row[4] = strtok(NULL,";");
            icon = gdk_pixmap_create_from_xpm (app.main_window->window,&mask,&app.main_window->style->white,row[4]);
			gtk_clist_append(GTK_CLIST(clist),row);
            if (icon)
                gtk_clist_set_pixmap(GTK_CLIST(clist),rownr,0,icon,mask);

			rownr++;
		}
        tmp = gtk_clist_optimal_column_width(GTK_CLIST(clist),1);
        if (tmp > 70)
            gtk_clist_set_column_width(GTK_CLIST(clist),1,tmp);
        else
            gtk_clist_set_column_width(GTK_CLIST(clist),1,70);

        tmp = gtk_clist_optimal_column_width(GTK_CLIST(clist),2);
        if (tmp > 50)
            gtk_clist_set_column_width(GTK_CLIST(clist),2,tmp);
        else
            gtk_clist_set_column_width(GTK_CLIST(clist),2,50);
        
        tmp = gtk_clist_optimal_column_width(GTK_CLIST(clist),3);
        if (tmp > 50)
            gtk_clist_set_column_width(GTK_CLIST(clist),3,tmp);
        else
            gtk_clist_set_column_width(GTK_CLIST(clist),3,50);

		fclose(fp);
	}
	gtk_clist_thaw(GTK_CLIST(clist));

}

void toolbar_remove(GtkWidget *wid, GtkWidget *clist)
{
    gtk_clist_remove(GTK_CLIST(clist),toolbar_selectedrow);
    write_toolbar(clist);
}
void toolbar_add(GtkWidget *wid, GtkWidget *clist)
{
    gint tmp_row;

    tmp_row = toolbar_selectedrow;
    toolbar_selectedrow = -1;
    create_toolbar_new_dialog("Add toolbar button","","","","",clist);
    gtk_main();
    toolbar_selectedrow = tmp_row; 
}
void toolbar_edit(GtkWidget *wid, GtkWidget *clist)
{
    gchar *buf1,*buf2,*buf3,*buf4;
    
    gtk_clist_get_text(GTK_CLIST(clist),toolbar_selectedrow,1,&buf1);
	gtk_clist_get_text(GTK_CLIST(clist),toolbar_selectedrow,2,&buf2);
	gtk_clist_get_text(GTK_CLIST(clist),toolbar_selectedrow,3,&buf3);
    gtk_clist_get_text(GTK_CLIST(clist),toolbar_selectedrow,4,&buf4);

    create_toolbar_new_dialog("Edit toolbar button",buf1,buf2,buf3,buf4,clist);
    gtk_main();
}

void cb_toolbar_dblclick(GtkWidget *clist, GdkEventButton *event,FileList *list)
{
    if(event->type == GDK_2BUTTON_PRESS)
    {
        create_prefs_window("Preferences",600,500,2);
    	gtk_main();
    }
}

void cb_toolbar_click(GtkWidget *wid, gchar *cmd)
{
    gchar *tmp;
    tmp = parse_program_string(cmd);
    execute_program(tmp);
}

void create_toolbar_new_dialog(gchar *title,gchar *txt1,gchar *txt2,gchar *txt3,gchar *txt4,GtkWidget *clist)
{
	GtkWidget *label;
	GtkWidget *button;
	GtkWidget *frame;
	GtkWidget *table;
	GtkWidget *hbox,*vbox;
	
	gint policy[3] = {0,1,1};

	toolbar_new_window = create_window(title,450,183,policy);
	gtk_signal_connect(GTK_OBJECT(toolbar_new_window),"delete-event",
						GTK_SIGNAL_FUNC(cb_delete_event),NULL);
	gtk_container_set_border_width(GTK_CONTAINER(toolbar_new_window),5);
	
	vbox = gtk_vbox_new(FALSE,5);
	gtk_container_add(GTK_CONTAINER(toolbar_new_window),vbox);
	gtk_widget_show(vbox);

	frame = gtk_frame_new(0);
	gtk_box_pack_start(GTK_BOX(vbox),frame,0,0,5);
	gtk_widget_show(frame);
	
	table = gtk_table_new(5,3,FALSE);
	gtk_container_set_border_width(GTK_CONTAINER(table),5);
	gtk_container_add(GTK_CONTAINER(frame),table);
	gtk_widget_show(table);
	
	label = gtk_label_new("Name: ");
	gtk_label_set_justify(GTK_LABEL(label),GTK_JUSTIFY_RIGHT);
	gtk_table_attach(GTK_TABLE(table),label,0,1,0,1,GTK_FILL,0,5,0);
	gtk_widget_show(label);

	entry1 = create_entry(txt1,0,NULL,NULL);
	gtk_table_attach(GTK_TABLE(table),entry1,1,2,0,1,GTK_FILL | GTK_EXPAND,0,5,0);

	label = gtk_label_new("Tooltip: ");
	gtk_label_set_justify(GTK_LABEL(label),GTK_JUSTIFY_LEFT);
	gtk_table_attach(GTK_TABLE(table),label,0,1,1,2,GTK_FILL,1,5,0);
	gtk_widget_show(label);

	entry2 = create_entry(txt2,0,NULL,NULL);
	gtk_table_attach(GTK_TABLE(table),entry2,1,2,1,2,GTK_FILL | GTK_EXPAND,0,5,0);

	label = gtk_label_new("Command: ");
	gtk_label_set_justify(GTK_LABEL(label),GTK_JUSTIFY_LEFT);
	gtk_table_attach(GTK_TABLE(table),label,0,1,2,3,GTK_FILL,1,5,0);
	gtk_widget_show(label);

	entry3 = create_entry(txt3,0,NULL,NULL);
	gtk_table_attach(GTK_TABLE(table),entry3,1,2,2,3,GTK_FILL | GTK_EXPAND,0,5,0);

    button = create_button("Insert",create_functions_dialog,entry3);
    gtk_table_attach(GTK_TABLE(table),button,2,3,2,3,GTK_FILL,1,5,0);
    
    label = gtk_label_new("Icon: ");
	gtk_label_set_justify(GTK_LABEL(label),GTK_JUSTIFY_LEFT);
	gtk_table_attach(GTK_TABLE(table),label,0,1,3,4,GTK_FILL,1,5,0);
	gtk_widget_show(label);

	entry4 = create_entry(txt4,0,NULL,NULL);
	gtk_table_attach(GTK_TABLE(table),entry4,1,2,3,4,GTK_FILL | GTK_EXPAND,0,5,0);
	
    button = create_button("Browse",cb_toolbar_browse_file,NULL);
    gtk_table_attach(GTK_TABLE(table),button,2,3,3,4,GTK_FILL,1,5,0);
    
	hbox = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,0,0,0);
	gtk_widget_show(hbox);

	button = create_button("OK",cb_toolbar_new_ok,clist);
	gtk_box_pack_end(GTK_BOX(hbox),button,1,1,5);
	gtk_widget_grab_default(GTK_WIDGET(button));
	button = create_button("Cancel",cb_toolbar_new_cancel,clist);
	gtk_box_pack_end(GTK_BOX(hbox),button,1,1,5);
	
	gtk_window_set_position (GTK_WINDOW (toolbar_new_window), GTK_WIN_POS_CENTER);
	gtk_widget_show(toolbar_new_window);
	gtk_window_set_transient_for (GTK_WINDOW (toolbar_new_window),GTK_WINDOW (app.main_window));
	gtk_grab_add(toolbar_new_window);
    gtk_widget_grab_focus(entry1);
	
}

