/* Linux Commander
 * Copyright (C) 2000 Per Holmng.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "linuxcmd.h"
#include "folder.xpm"
#include "file.xpm"

GtkWidget *entry_str;
GtkWidget *entry_dir;
GtkWidget *chk_internal;
GtkWidget *chk_locate;
GtkWidget *chk_ignore_hidden;
GtkWidget *search_window;
GtkWidget *statusbar;
GtkWidget *button_close;

gboolean continue_search = FALSE;
gint counter = 0;

void search(gchar *dir, gchar *str,GtkWidget *clist)
{
    DIR *dh;
    struct dirent *dp;
    struct stat statbuf;
    gchar *tmp;
    gchar *buf[2];
    gchar *statustext;
    gint rownr;
    gint mode;
    gint ignore_hidden;
    GdkPixmap *pixmapfile,*pixmapfolder;
    GdkBitmap *mask;

    pixmapfolder = gdk_pixmap_create_from_xpm_d(app.main_window->window,&mask,0,folder_xpm);
	pixmapfile = gdk_pixmap_create_from_xpm_d(app.main_window->window, &mask,0,file_xpm);
    ignore_hidden = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(chk_ignore_hidden));

    mode = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(chk_internal));
    
    if (mode == 1)
    {
        if (continue_search == TRUE && (dh = opendir(dir)))
        {
            statustext = malloc(strlen(dir)+50);
            sprintf(statustext,"[%d results] - Searching in: %s",counter,dir);
            gtk_statusbar_push(GTK_STATUSBAR(statusbar),1,statustext);    
            g_free(statustext);
    
            while ((dp = readdir (dh)) != NULL)
            {
                while(gtk_events_pending())
	    			gtk_main_iteration();
                if (ignore_hidden == 1)
                {
                    if (dp->d_name[0] == '.')
                        continue;
    
                }
                if (strcmp(dp->d_name,".") != 0 && strcmp(dp->d_name,"..") != 0)
                {
                    if (strcmp(dir,"/") == 0)
                    {
                        tmp = malloc(strlen(dp->d_name)+2);
                        sprintf(tmp,"/%s",dp->d_name);
                    }
                    else
                    {
                        tmp = malloc(strlen(dir)+strlen(dp->d_name)+2);
                        sprintf(tmp,"%s/%s",dir,dp->d_name);
                    }
                    stat(tmp,&statbuf);
                    if (fnmatch(str,dp->d_name,0) == 0)
                    {                
                        buf[0] = "";
                        buf[1] = tmp;
                        rownr = gtk_clist_append(GTK_CLIST(clist),buf);
                        if (S_ISDIR(statbuf.st_mode))
                            gtk_clist_set_pixtext(GTK_CLIST(clist),rownr,0,tmp,5,pixmapfolder,mask);
                        else
                            gtk_clist_set_pixtext(GTK_CLIST(clist),rownr,0,tmp,5,pixmapfile,mask);
                        counter++;
                    }         
                        if (S_ISDIR (statbuf.st_mode))
                            search(strdup(tmp),str,clist);
                    g_free(tmp);
                }
            }
            closedir(dh);
        }
    }
    else
    {   
        gchar *locate_cmd;
        gchar rbuf[1024];
        gchar *strip;
        FILE *locate;
        
        locate_cmd = malloc(strlen(str)+10);
        sprintf(locate_cmd,"locate %s",str);
        
        locate = popen(locate_cmd,"r");
        while (fgets(rbuf,1024,locate) != NULL)
        {
            statustext = malloc(strlen(dir)+50);
            sprintf(statustext,"[%d results]",counter);
            gtk_statusbar_push(GTK_STATUSBAR(statusbar),1,statustext);    
            g_free(statustext);

            while(gtk_events_pending())
	    		gtk_main_iteration();

           if ((strip = strchr(rbuf,'\n')))
               *strip = 0;
            stat(rbuf,&statbuf);
            buf[0] = "";
            buf[1] = rbuf;
            rownr = gtk_clist_append(GTK_CLIST(clist),buf);
            if (S_ISDIR(statbuf.st_mode))
                gtk_clist_set_pixtext(GTK_CLIST(clist),rownr,0,rbuf,5,pixmapfolder,mask);
            else
                gtk_clist_set_pixtext(GTK_CLIST(clist),rownr,0,rbuf,5,pixmapfile,mask);
            counter++;
        }
        pclose(locate);
    }
}

void cb_entry_grab_focus(GtkWidget *wid, gpointer data)
{
    gchar *buf;
    buf = gtk_entry_get_text(GTK_ENTRY(wid));
    gtk_entry_select_region(GTK_ENTRY(wid),0,strlen(buf));
}

void find_and_select_file(gchar *filename)
{
    gchar *buf;
    gint a;
    
    for (a = 1; a < GTK_CLIST(focused->clist)->rows; a++)
	{
		gtk_clist_get_text(GTK_CLIST(focused->clist),a,5,&buf);	
		if (strcmp(buf,filename) == 0)
			break;
	}

    gtk_clist_select_row(GTK_CLIST(focused->clist),a,0);
    GTK_CLIST(focused->clist)->focus_row = a;
    gtk_clist_sort(GTK_CLIST(focused->clist));
    gtk_clist_moveto(GTK_CLIST(focused->clist),a,0,0.5,0.5);
    gtk_widget_grab_focus(GTK_WIDGET(focused->clist));
}

void cb_search_clist_select_row(GtkWidget *clist, gint row,gint column,
        						GdkEvent *event, gpointer data)
{
    if (event)
    {
		if(event->type == GDK_2BUTTON_PRESS)
		{
            gchar *rowdata;
			gchar *tmp;
            gchar *dir;
            struct stat statbuf;
            
            gtk_clist_get_text(GTK_CLIST(clist),row,1,&rowdata);
            stat(rowdata,&statbuf);
            
            if (S_ISDIR(statbuf.st_mode))
            {
                update_filelist(rowdata,focused);
                gtk_widget_grab_focus(GTK_WIDGET(focused->clist));

            }
            else
            {
                tmp = malloc(strlen(rowdata));
                tmp = strrchr(rowdata,'/');
                dir = substr(rowdata,1,strlen(rowdata)-strlen(tmp));
                update_filelist(dir,focused);
                find_and_select_file(rowdata);
            }
		}
    }
}


void cb_search_search(GtkWidget *wid, GtkWidget *clist)
{
    gchar *buf1,*buf2;
    gint mode;
    gchar *state;
    gchar *statustext;

    statustext = malloc(30);

    gtk_label_get(GTK_LABEL(GTK_BUTTON(wid)->child),&state);
    
    if (strcmp(state,"Search") ==  0)
    {
        counter = 0;
        continue_search = TRUE;
    
        gtk_widget_set_sensitive(GTK_WIDGET(button_close),FALSE);
        gtk_label_set_text(GTK_LABEL(GTK_BUTTON(wid)->child),"Stop");
        gtk_clist_clear(GTK_CLIST(clist));
    
        buf1 = gtk_entry_get_text(GTK_ENTRY(entry_str));
        buf2 = gtk_entry_get_text(GTK_ENTRY(entry_dir));

        search(buf2,buf1,clist);
        gtk_label_set_text(GTK_LABEL(GTK_BUTTON(wid)->child),"Search");
        gtk_widget_set_sensitive(GTK_WIDGET(button_close),TRUE);
        continue_search = FALSE;
        sprintf(statustext,"[%d results] - Search ended",counter);
        gtk_statusbar_push(GTK_STATUSBAR(statusbar),1,statustext);    
        free(statustext);
        cb_entry_grab_focus(entry_dir,NULL);
        cb_entry_grab_focus(entry_str,NULL);
        gtk_widget_grab_focus(GTK_WIDGET(entry_str));
    }
    else
    {
        continue_search = FALSE;
        gtk_label_set_text(GTK_LABEL(GTK_BUTTON(wid)->child),"Search");
    }
}

void cb_search_close(GtkWidget *wid,gpointer d)
{
    if (continue_search != TRUE)
        gtk_widget_destroy(search_window);
}

void create_search_window()
{
    GtkWidget *hbox,*vbox;
    GtkWidget *label;
    GtkWidget *frame;
    GtkWidget *table;
    GtkWidget *clist;
    GtkWidget *button;
    GtkWidget *scrolled_window;
    GSList *group;

    gchar *titles[2] = { "Filename","Filename" };
    gint policy[3] = {0,1,1};
    search_window = create_window("Search",700,600,policy);
    gtk_signal_connect (GTK_OBJECT (search_window), "delete-event",GTK_SIGNAL_FUNC(cb_search_close),NULL);
    gtk_container_set_border_width(GTK_CONTAINER(search_window),5);
    
    vbox = gtk_vbox_new(FALSE,0);
    gtk_container_add(GTK_CONTAINER(search_window),vbox);
    gtk_widget_show(vbox);

    frame = gtk_frame_new(0);
	gtk_box_pack_start(GTK_BOX(vbox),frame,0,0,0);
	gtk_widget_show(frame);
	
	table = gtk_table_new(3,4,FALSE);
	gtk_container_set_border_width(GTK_CONTAINER(table),5);
	gtk_container_add(GTK_CONTAINER(frame),table);
	gtk_widget_show(table);

    label = gtk_label_new("Search string: ");
    gtk_table_attach(GTK_TABLE(table),label,0,1,0,1,GTK_FILL,5,5,5);
    gtk_widget_show(label);
    entry_str = create_entry("",0,NULL,NULL);
    gtk_signal_connect(GTK_OBJECT(entry_str),"grab-focus",GTK_SIGNAL_FUNC(cb_entry_grab_focus),NULL);
    gtk_table_attach(GTK_TABLE(table),entry_str,1,3,0,1,GTK_FILL | GTK_EXPAND,0,5,0);
    
    label = gtk_label_new("Directory: ");
    gtk_table_attach(GTK_TABLE(table),label,0,1,1,2,GTK_FILL,5,5,5);

    gtk_widget_show(label);
    gtk_label_set_justify(GTK_LABEL(label),GTK_JUSTIFY_LEFT);
    
    entry_dir = create_entry(focused->workingdir,0,NULL,NULL);
    gtk_signal_connect(GTK_OBJECT(entry_dir),"grab-focus",GTK_SIGNAL_FUNC(cb_entry_grab_focus),NULL);
    gtk_table_attach(GTK_TABLE(table),entry_dir,1,2,1,2,GTK_FILL | GTK_EXPAND,0,5,0);

    button = create_browse_button(cb_browsedir,entry_dir);
    gtk_table_attach(GTK_TABLE(table),button,2,3,1,2,GTK_FILL,0,5,0);

    label = gtk_label_new("Search mode: ");
    gtk_table_attach(GTK_TABLE(table),label,0,1,2,3,GTK_FILL,0,5,0);
    gtk_widget_show(label);

    hbox = gtk_hbox_new(FALSE,5);
    gtk_table_attach_defaults (GTK_TABLE(table), hbox, 1, 3,2,3);
    gtk_widget_show(hbox);
    
    chk_internal = gtk_radio_button_new_with_label (NULL, "Internal");
    gtk_box_pack_start(GTK_BOX(hbox),chk_internal,0,0,5);
    gtk_widget_show(chk_internal);
    
    group = gtk_radio_button_group (GTK_RADIO_BUTTON (chk_internal));
    chk_locate = gtk_radio_button_new_with_label(group, "Locate");
    gtk_box_pack_start(GTK_BOX(hbox),chk_locate,0,0,5);
    gtk_widget_show(chk_locate);

    label = gtk_label_new("Options: ");
    gtk_table_attach(GTK_TABLE(table),label,0,1,3,4,GTK_FILL,0,5,0);
    gtk_widget_show(label);

    hbox = gtk_hbox_new(FALSE,5);
    gtk_table_attach_defaults (GTK_TABLE(table), hbox, 1,3,3,4);
    gtk_widget_show(hbox);
    
    chk_ignore_hidden = gtk_check_button_new_with_label ("Ignore hidden files");
    gtk_box_pack_start(GTK_BOX(hbox),chk_ignore_hidden,0,0,5);
    gtk_widget_show(chk_ignore_hidden);

    hbox = gtk_hbox_new(FALSE,0);
    gtk_box_pack_start(GTK_BOX(vbox),hbox,0,0,5);
    gtk_widget_show(hbox);
    
    clist = gtk_clist_new_with_titles(2,titles);
    gtk_clist_set_column_visibility(GTK_CLIST(clist),1,0);
    
    button = create_button("Search",cb_search_search,clist);
    gtk_box_pack_start(GTK_BOX(hbox),button,0,0,0);
    gtk_widget_set_usize(GTK_WIDGET(button),80,35);
    
    button_close = create_button("Close",cb_search_close,NULL);
    gtk_box_pack_start(GTK_BOX(hbox),button_close,0,0,0);
    gtk_widget_set_usize(GTK_WIDGET(button_close),80,35);

    frame = gtk_frame_new(0);
	gtk_box_pack_start(GTK_BOX(vbox),frame,1,1,0);
	gtk_widget_show(frame);

    hbox = gtk_hbox_new(FALSE,0);
    gtk_container_add(GTK_CONTAINER(frame),hbox);
    gtk_widget_show(hbox);

    scrolled_window = gtk_scrolled_window_new(NULL,NULL);
	gtk_container_set_border_width(GTK_CONTAINER(scrolled_window),5);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
                                    GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start(GTK_BOX(hbox),scrolled_window,1,1,0);
	gtk_widget_show(scrolled_window);
	
    gtk_signal_connect(GTK_OBJECT(clist), "select_row",
	                   	GTK_SIGNAL_FUNC(cb_search_clist_select_row),NULL);
	gtk_container_add(GTK_CONTAINER(scrolled_window), clist);
	gtk_widget_show(clist);

    statusbar = gtk_statusbar_new();
	gtk_box_pack_start(GTK_BOX(vbox),statusbar,0,0,5);
	gtk_widget_show(statusbar);

    gtk_window_set_position (GTK_WINDOW (search_window), GTK_WIN_POS_CENTER);
    gtk_widget_show(search_window);
    
    gtk_widget_grab_focus(GTK_WIDGET(entry_str));
}


