/* Linux Commander
 * Copyright (C) 2000 Per Holmng.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "linuxcmd.h"

float size = 0;

gint recurse(gchar *dir)
{
    DIR *dirh;
	struct dirent *dirp;
    struct stat statbuf;
    gchar *tmp;
    
    if ((dirh = opendir(dir)) == NULL)
	{
		return -1; 
	}
	while ((dirp = readdir (dirh)) != NULL)
	{
        if (STREQ (dirp->d_name, "."))
			continue;
        if (STREQ (dirp->d_name, ".."))
			continue;
        tmp = malloc(strlen(dir)+strlen(dirp->d_name)+3);
        sprintf(tmp,"%s/%s",dir,dirp->d_name);
        stat(tmp, &statbuf);        
        if (S_ISDIR(statbuf.st_mode))
        {
            recurse(tmp);
        }
        else
        {
            size += (float)statbuf.st_size / 1024 / 1024;
        }
    }
    closedir(dirh);
    return 1;
}

void cb_dir_recurse_count_size(FileList *list)
{
    GString *sz = g_string_new("");
    size = 0;
    recurse(list->selectedfile);
    g_string_sprintf(sz,"%.2fMb",size);
    gtk_clist_set_text(GTK_CLIST(list->clist),focused->selectedrow,1,sz->str);
}

