/* Linux Commander
 * Copyright (C) 2000 Per Holmng.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "linuxcmd.h"

GtkWidget *colorseldlg = NULL;
GtkWidget *fontseldlg = NULL;
GtkWidget *ass_clist;
GtkWidget *toolbar_clist;
GtkWidget *pref_window;
/*************************/
GtkWidget *entry_leftdir;
GtkWidget *entry_rightdir;
GtkWidget *entry_xterm;
GtkWidget *entry_fileviewfont;
GtkWidget *entry1,*entry2,*entry3,*entry4;
GtkWidget *cmb_toolbar_style;
/*************************/
GtkWidget *check_del_confirmation;
GtkWidget *check_cmddel_confirmation;
GtkWidget *chk_show_hidden_files;
/*************************/
GtkWidget *dblclick_exe_execute;
GtkWidget *dblclick_exe_fileinfo;
GtkWidget *dblclick_norm_fileinfo;
/********************************/
GtkWidget *chk_column1_visible;
GtkWidget *chk_column2_visible;
GtkWidget *chk_column3_visible;
GtkWidget *chk_column4_visible;
GtkWidget *chk_column5_visible;
/***************************************************/
GtkWidget *chk_expand_links;
GtkWidget *chk_lynxlike_motion;
/***************************/
GtkWidget *cmb_selectbutton;
GtkWidget *cmb_popupbutton;
/***************************/

gint selectedrow = -1;

void close_prefs_window(GtkWidget *widget, gpointer data)
{
    gtk_grab_remove(pref_window);
  	gtk_widget_destroy (pref_window);
    gtk_main_quit();
}

void cb_fontsel_ok(GtkWidget *wid,gpointer data)
{
    GtkStyle *style = gtk_style_new ();
    //strcpy(config.fileview_font_str,gtk_font_selection_dialog_get_font_name(GTK_FONT_SELECTION_DIALOG(fontseldlg)));
  	style->font = gtk_font_selection_dialog_get_font(GTK_FONT_SELECTION_DIALOG(fontseldlg));
 	gtk_widget_set_style (GTK_WIDGET(data), style);
    gtk_widget_destroy(fontseldlg);

}

void cb_fontsel_cancel(GtkWidget *wid,gpointer data)
{
    gtk_widget_destroy(fontseldlg);
}


void cb_selectfont( GtkWidget *wid, gpointer data)
{
    fontseldlg  = gtk_font_selection_dialog_new("Select font");
    gtk_signal_connect(GTK_OBJECT(GTK_FONT_SELECTION_DIALOG(fontseldlg )->ok_button),"clicked",
									GTK_SIGNAL_FUNC(cb_fontsel_ok),(gpointer)wid);
	gtk_signal_connect(GTK_OBJECT(GTK_FONT_SELECTION_DIALOG(fontseldlg )->cancel_button),"clicked",
									GTK_SIGNAL_FUNC(cb_fontsel_cancel),NULL);
    gtk_widget_show(fontseldlg);
}

void write_config()
{
	strcpy(config.startupdir_left,gtk_entry_get_text(GTK_ENTRY(entry_leftdir)));
	strcpy(config.startupdir_right,gtk_entry_get_text(GTK_ENTRY(entry_rightdir)));
	strcpy(config.xterm,gtk_entry_get_text(GTK_ENTRY(entry_xterm)));
	config.col1_visible = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(chk_column1_visible));
	config.col2_visible = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(chk_column2_visible));
	config.col3_visible = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(chk_column3_visible));
	config.col4_visible = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(chk_column4_visible));
	config.col5_visible = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(chk_column5_visible));
	config.expand_links = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(chk_expand_links));
	config.confirmation_del_normal = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_del_confirmation));
	config.confirmation_del_cmdline = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_cmddel_confirmation));
	config.lynxlike_motion = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(chk_lynxlike_motion));
    config.show_hidden_files = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(chk_show_hidden_files));
	if (strcmp("Middle",gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(cmb_selectbutton)->entry))) == 0)
		config.select_button = 2;
	else 
		config.select_button = 3;
	
	if (strcmp("Middle",gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(cmb_popupbutton)->entry))) == 0)
		config.popup_button = 2;
	else 
		config.popup_button = 3;
	
	if (config.popup_button == config.select_button)
	{
		config.select_button = 3;
		config.popup_button = 2;
	}

    if (strcmp("Icons",gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(cmb_toolbar_style)->entry))) == 0)
        config.toolbar_style = GTK_TOOLBAR_ICONS;
    else if (strcmp("Text",gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(cmb_toolbar_style)->entry))) == 0)
        config.toolbar_style = GTK_TOOLBAR_TEXT;
    else if(strcmp("Both",gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(cmb_toolbar_style)->entry))) == 0)
        config.toolbar_style = GTK_TOOLBAR_BOTH;

	write_config_file();
}

void cb_prefs_apply()
{
	write_config();
	recreate_filelists();
}

void cb_prefs_ok()
{
	write_config();
	close_prefs_window(NULL,NULL);
	recreate_filelists();
}

void create_prefs_window(const gchar *title, gint xsize, gint ysize,gint def)
{
	GtkWidget *notebook;
	GtkWidget *table,*table2;
	GtkWidget *frame;
	GtkWidget *label;
    GtkWidget *scrolled_window;
	GtkWidget *vbox;
	GtkWidget *vbox2;
	GtkWidget *hbox;
	GtkWidget *button;
	GtkStyle *style;
	GList *buttons = NULL;
    GList *toolbar_styles = NULL;
	gint policy[3] = { 0,1,0 };
    gchar *ass_titles[3] = { "Extension(s)", "Name","Command" };
    gchar *toolbar_titles[5] = { "", "Name","Tooltip","Command","Icon" };
	
	pref_window = create_window((char *)strdup(title),xsize,ysize,policy);
	gtk_container_set_border_width(GTK_CONTAINER(pref_window),5);
	gtk_signal_connect(GTK_OBJECT(pref_window),"delete-event",
						GTK_SIGNAL_FUNC(cb_delete_event),NULL);
	table = gtk_table_new(3,3,FALSE);
    gtk_container_add (GTK_CONTAINER (pref_window), table);

	notebook = gtk_notebook_new();
	gtk_notebook_set_tab_pos(GTK_NOTEBOOK(notebook),GTK_POS_TOP);
	gtk_table_attach_defaults(GTK_TABLE(table), notebook, 0,3,0,1);
	gtk_widget_show(notebook);
	gtk_widget_show(table);
	
    /* Directories */
    
	vbox = gtk_vbox_new(FALSE,5);
	gtk_widget_show(vbox);
	
	hbox = gtk_hbox_new(FALSE,5);
	gtk_widget_show(hbox);
	frame = gtk_frame_new ("Left startup directory");
	gtk_box_pack_start(GTK_BOX(vbox),frame,0,1,0);
    gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
    gtk_widget_set_usize (frame, 100, 70);
	entry_leftdir = create_entry(config.startupdir_left,255,NULL,NULL);
	gtk_container_add(GTK_CONTAINER(frame),hbox);
	gtk_box_pack_start(GTK_BOX(hbox),entry_leftdir,1,1,5);
    gtk_widget_show(frame);

	hbox = gtk_hbox_new(FALSE,5);
	gtk_widget_show(hbox);
	frame = gtk_frame_new ("Right startup directory");
	gtk_box_pack_start(GTK_BOX(vbox),frame,0,1,0);
    gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
    gtk_widget_set_usize (frame, 100, 70);
	entry_rightdir = create_entry(config.startupdir_right,255,NULL,NULL);
	gtk_container_add(GTK_CONTAINER(frame),hbox);
	gtk_box_pack_start(GTK_BOX(hbox),entry_rightdir,1,1,5);
    gtk_widget_show(frame);

	label = gtk_label_new("Directories");
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), vbox,label);

    /* File associations */
        
    vbox = gtk_vbox_new(FALSE,5);
	gtk_widget_show(vbox);
    
    gdk_color_parse("blue",&color_def);
    
    scrolled_window = gtk_scrolled_window_new(NULL,NULL);
	gtk_container_set_border_width(GTK_CONTAINER(scrolled_window),5);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
                                    GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start(GTK_BOX(vbox),scrolled_window,1,1,0);
	gtk_widget_show(scrolled_window);
	
	ass_clist = gtk_clist_new_with_titles(3,ass_titles);
	gtk_signal_connect(GTK_OBJECT(ass_clist),"select-row",cb_ass_clist_select_row,NULL);
    gtk_signal_connect(GTK_OBJECT(ass_clist),"unselect-row",cb_ass_clist_unselect_row,NULL);
	gtk_container_add(GTK_CONTAINER(scrolled_window), ass_clist);
	gtk_widget_show(ass_clist);
	
	hbox = gtk_hbox_new(FALSE,5);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,0,0,5);
	gtk_widget_show(hbox);
	
	button = create_button("New...",ass_new,ass_clist);
	gtk_box_pack_start(GTK_BOX(hbox),button,1,1,5);
	gtk_widget_grab_default(GTK_WIDGET(button));
	button = create_button("Remove",ass_remove,ass_clist);
	gtk_box_pack_start(GTK_BOX(hbox),button,1,1,5);
	button = create_button("Edit",ass_edit,ass_clist);
	gtk_box_pack_start(GTK_BOX(hbox),button,1,1,5);

    get_associations(ass_clist);
    
    label = gtk_label_new("Filetypes");
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), vbox,label);
    
	vbox = gtk_vbox_new(FALSE,5);
	gtk_widget_show(vbox);
    
    /* Toolbar */

    vbox = gtk_vbox_new(FALSE,0);
	gtk_widget_show(vbox);

    hbox = gtk_hbox_new(FALSE,0);
    gtk_box_pack_start(GTK_BOX(vbox),hbox,0,0,5);
    gtk_widget_show(hbox);
    
    vbox2 = gtk_vbox_new(FALSE,0);
	gtk_widget_show(vbox2);


  	toolbar_styles = g_list_append(toolbar_styles,"Icons");
    toolbar_styles = g_list_append(toolbar_styles,"Text");
	toolbar_styles = g_list_append(toolbar_styles,"Both");

	frame = gtk_frame_new ("Toolbar style");
	gtk_box_pack_start(GTK_BOX(vbox),frame,0,1,0);
    gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
	gtk_container_set_border_width (GTK_CONTAINER (vbox2), 5);
    gtk_widget_set_usize (frame, 100, 60);
	cmb_toolbar_style = gtk_combo_new();
	gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(cmb_toolbar_style)->entry),0);
    gtk_combo_set_popdown_strings(GTK_COMBO(cmb_toolbar_style),toolbar_styles);
	if (config.toolbar_style == GTK_TOOLBAR_ICONS)
		gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(cmb_toolbar_style)->entry),"Icons");
	else if (config.toolbar_style == GTK_TOOLBAR_TEXT)
		gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(cmb_toolbar_style)->entry),"Text");
    else if (config.toolbar_style == GTK_TOOLBAR_BOTH)
		gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(cmb_toolbar_style)->entry),"Both");
    else
        gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(cmb_toolbar_style)->entry),"Icons");
	gtk_container_add(GTK_CONTAINER(frame),vbox2);
	gtk_box_pack_start(GTK_BOX(vbox2),cmb_toolbar_style,0,0,0);
	gtk_widget_show(cmb_toolbar_style);
    gtk_widget_show(frame);

    scrolled_window = gtk_scrolled_window_new(NULL,NULL);
	gtk_container_set_border_width(GTK_CONTAINER(scrolled_window),5);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
                                    GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start(GTK_BOX(vbox),scrolled_window,1,1,0);
	gtk_widget_show(scrolled_window);
	
	toolbar_clist = gtk_clist_new_with_titles(5,toolbar_titles);
    gtk_signal_connect(GTK_OBJECT(toolbar_clist),"select-row",cb_toolbar_clist_select_row,NULL);
    gtk_signal_connect(GTK_OBJECT(toolbar_clist),"unselect-row",cb_toolbar_clist_unselect_row,NULL);
	gtk_container_add(GTK_CONTAINER(scrolled_window), toolbar_clist);
    
    get_toolbar(toolbar_clist);
    
    gtk_clist_set_column_width(GTK_CLIST(toolbar_clist),0,gtk_clist_optimal_column_width(GTK_CLIST(toolbar_clist),0));
	gtk_widget_show(toolbar_clist);

    hbox = gtk_hbox_new(FALSE,5);
    gtk_box_pack_start(GTK_BOX(vbox),hbox,0,0,5);
    gtk_widget_show(hbox);
    
    button = create_button("Add",toolbar_add,toolbar_clist);
    gtk_box_pack_start(GTK_BOX(hbox),button,1,1,5);
    gtk_widget_grab_default(GTK_WIDGET(button));
    gtk_widget_show(button);
    
    button = create_button("Edit",toolbar_edit,toolbar_clist);
    gtk_box_pack_start(GTK_BOX(hbox),button,1,1,5);
    gtk_widget_show(button);
    
    button = create_button("Remove",toolbar_remove,toolbar_clist);
    gtk_box_pack_start(GTK_BOX(hbox),button,1,1,5);
    gtk_widget_show(button);
    
    label = gtk_label_new("Toolbar");
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), vbox,label);
    
	vbox = gtk_vbox_new(FALSE,5);
	gtk_widget_show(vbox);

    /* Misc */
	
	vbox2 = gtk_vbox_new(FALSE,0);
	gtk_widget_show(vbox2);
	
	frame = gtk_frame_new ("Ask for confirmation");
	gtk_box_pack_start(GTK_BOX(vbox),frame,0,1,0);
    gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
	gtk_container_set_border_width (GTK_CONTAINER (vbox2), 5);
    gtk_widget_set_usize (frame, 100, 90);
	check_del_confirmation = gtk_check_button_new_with_label("When deleting?");
	check_cmddel_confirmation = gtk_check_button_new_with_label("When deleting from the command line?");
	gtk_container_add(GTK_CONTAINER(frame),vbox2);
	gtk_box_pack_start(GTK_BOX(vbox2),check_del_confirmation,0,0,0);
	gtk_box_pack_start(GTK_BOX(vbox2),check_cmddel_confirmation,0,0,0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_del_confirmation),config.confirmation_del_normal);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_cmddel_confirmation),config.confirmation_del_cmdline);
	gtk_widget_show(check_del_confirmation);
	gtk_widget_show(check_cmddel_confirmation);
    gtk_widget_show(frame);

	vbox2 = gtk_vbox_new(FALSE,0);
	gtk_widget_show(vbox2);
	
	frame = gtk_frame_new ("XTerm Command");
	gtk_box_pack_start(GTK_BOX(vbox),frame,0,1,0);
    gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
	gtk_container_set_border_width (GTK_CONTAINER (vbox2), 5);
    gtk_widget_set_usize (frame, 100, 60);
	gtk_container_add(GTK_CONTAINER(frame),vbox2);
	
	entry_xterm = create_entry(config.xterm,255,NULL,NULL);
	gtk_box_pack_start(GTK_BOX(vbox2),entry_xterm,0,0,0);
	gtk_widget_show(entry_xterm);
    gtk_widget_show(frame);

	label = gtk_label_new("Misc");
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), vbox,label);
	
	vbox = gtk_vbox_new(FALSE,5);
	gtk_widget_show(vbox);
	
	vbox2 = gtk_vbox_new(FALSE,0);
	gtk_widget_show(vbox2);
	
	frame = gtk_frame_new ("Visible columns");
	gtk_box_pack_start(GTK_BOX(vbox),frame,0,1,0);
    gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
	gtk_container_set_border_width (GTK_CONTAINER (vbox2), 5);
    gtk_widget_set_usize (frame, 100, 160);
	chk_column1_visible = gtk_check_button_new_with_label("#1 - Filename");
	chk_column2_visible = gtk_check_button_new_with_label("#2 - Size");
	chk_column3_visible = gtk_check_button_new_with_label("#3 - Owner");
	chk_column4_visible = gtk_check_button_new_with_label("#4 - Group");
	chk_column5_visible = gtk_check_button_new_with_label("#5 - Permissions");

	gtk_container_add(GTK_CONTAINER(frame),vbox2);
	gtk_box_pack_start(GTK_BOX(vbox2),chk_column1_visible,0,0,0);
	gtk_box_pack_start(GTK_BOX(vbox2),chk_column2_visible,0,0,0);
	gtk_box_pack_start(GTK_BOX(vbox2),chk_column3_visible,0,0,0);
	gtk_box_pack_start(GTK_BOX(vbox2),chk_column4_visible,0,0,0);
	gtk_box_pack_start(GTK_BOX(vbox2),chk_column5_visible,0,0,0);

	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chk_column1_visible),config.col1_visible);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chk_column2_visible),config.col2_visible);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chk_column3_visible),config.col3_visible);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chk_column4_visible),config.col4_visible);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chk_column5_visible),config.col5_visible);
	
	gtk_widget_show(chk_column1_visible);
	gtk_widget_show(chk_column2_visible);
	gtk_widget_show(chk_column3_visible);
	gtk_widget_show(chk_column4_visible);
	gtk_widget_show(chk_column5_visible);
    gtk_widget_show(frame);

	vbox2 = gtk_vbox_new(FALSE,0);
	gtk_widget_show(vbox2);

	frame = gtk_frame_new ("Misc");
	gtk_box_pack_start(GTK_BOX(vbox),frame,0,1,0);
    gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
	gtk_container_set_border_width (GTK_CONTAINER (vbox2), 5);
    gtk_widget_set_usize (frame, 100, 110);
	gtk_container_add(GTK_CONTAINER(frame),vbox2);

	chk_expand_links = gtk_check_button_new_with_label("Show extended info for links");
	gtk_box_pack_start(GTK_BOX(vbox2),chk_expand_links,0,0,0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chk_expand_links),config.expand_links);
	gtk_widget_show(chk_expand_links);

	chk_lynxlike_motion = gtk_check_button_new_with_label("Lynx-like motion");
	gtk_box_pack_start(GTK_BOX(vbox2),chk_lynxlike_motion,0,0,0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chk_lynxlike_motion),config.lynxlike_motion);
	gtk_widget_show(chk_lynxlike_motion);

    chk_show_hidden_files = gtk_check_button_new_with_label("Show hidden files");
	gtk_box_pack_start(GTK_BOX(vbox2),chk_show_hidden_files,0,0,0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chk_show_hidden_files),config.show_hidden_files);
	gtk_widget_show(chk_show_hidden_files);

    gtk_widget_show(frame);

	label = gtk_label_new("Filelist configuration");
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), vbox,label);

	vbox = gtk_vbox_new(FALSE,5);
	gtk_widget_show(vbox);
	
	vbox2 = gtk_vbox_new(FALSE,0);
	gtk_widget_show(vbox2);
	
	buttons = g_list_append(buttons,"Middle");
	buttons = g_list_append(buttons,"Right");

	frame = gtk_frame_new ("Select button");
	gtk_box_pack_start(GTK_BOX(vbox),frame,0,1,0);
    gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
	gtk_container_set_border_width (GTK_CONTAINER (vbox2), 5);
    gtk_widget_set_usize (frame, 100, 60);
	cmb_selectbutton = gtk_combo_new();
	gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(cmb_selectbutton)->entry),0);
	gtk_combo_set_popdown_strings(GTK_COMBO(cmb_selectbutton),buttons);
	if (config.select_button == 2)
		gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(cmb_selectbutton)->entry),"Middle");
	else
		gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(cmb_selectbutton)->entry),"Right");
	gtk_container_add(GTK_CONTAINER(frame),vbox2);
	gtk_box_pack_start(GTK_BOX(vbox2),cmb_selectbutton,0,0,0);
	gtk_widget_show(cmb_selectbutton);
    gtk_widget_show(frame);

	vbox2 = gtk_vbox_new(FALSE,0);
	gtk_widget_show(vbox2);

	frame = gtk_frame_new ("Popup button");
	gtk_box_pack_start(GTK_BOX(vbox),frame,0,1,0);
    gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
	gtk_container_set_border_width (GTK_CONTAINER (vbox2), 5);
    gtk_widget_set_usize (frame, 100, 60);
	cmb_popupbutton = gtk_combo_new();
	gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(cmb_popupbutton)->entry),0);
	gtk_combo_set_popdown_strings(GTK_COMBO(cmb_popupbutton),buttons);
	if (config.popup_button == 2)
		gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(cmb_popupbutton)->entry),"Middle");
	else
		gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(cmb_popupbutton)->entry),"Right");
	gtk_container_add(GTK_CONTAINER(frame),vbox2);
	gtk_box_pack_start(GTK_BOX(vbox2),cmb_popupbutton,0,0,0);
	gtk_widget_show(cmb_popupbutton);
    gtk_widget_show(frame);

	label = gtk_label_new("Mouse");
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), vbox,label);

	vbox = gtk_vbox_new(FALSE,5);
	gtk_widget_show(vbox);
	
	table2 = gtk_table_new(4,2,FALSE);
	gtk_widget_show(table2);

	frame = gtk_frame_new ("Visual");
	gtk_box_pack_start(GTK_BOX(vbox),frame,0,1,0);
    gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
	gtk_container_set_border_width (GTK_CONTAINER (table2), 5);
	gtk_container_add(GTK_CONTAINER(frame),table2);
    gtk_widget_set_usize (frame, 100, 90);

	label = gtk_label_new("Tagged files");
	gtk_label_set_justify( GTK_LABEL(label),GTK_JUSTIFY_LEFT);
	gtk_widget_show(label);
	
	button = gtk_button_new();
	gtk_widget_set_usize(GTK_WIDGET(button),70,15);
	style = gtk_style_new();
	style->bg[GTK_STATE_NORMAL] = color_tag;
  	gtk_widget_set_style (button, style);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
						cb_color_dialog_show,&color_tag);
	gtk_table_attach( GTK_TABLE(table2),label,0,1,0,1,0,0,5,5 );
	gtk_table_attach( GTK_TABLE(table2),button,1,2,0,1,0,0,5,5 );
	gtk_widget_show(button);

	label = gtk_label_new("Regular files");
	gtk_label_set_justify( GTK_LABEL(label),GTK_JUSTIFY_LEFT );
	gtk_widget_show(label);

	button = gtk_button_new();
	gtk_widget_set_usize(GTK_WIDGET(button),70,15);
	style = gtk_style_new();
	style->bg[GTK_STATE_NORMAL] = color_reg;
  	gtk_widget_set_style (button, style);
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
						cb_color_dialog_show,&color_reg);
	gtk_table_attach( GTK_TABLE(table2),label,0,1,1,2 ,0,0,0,5);
	gtk_table_attach( GTK_TABLE(table2),button,1,2,1,2,0,0,0,5 );
	gtk_widget_show(button);

    /*label = gtk_label_new("Font in fileviewer");
	gtk_label_set_justify( GTK_LABEL(label),GTK_JUSTIFY_LEFT );
	gtk_widget_show(label);
    
    button = create_button("Select font",cb_selectfont,NULL);
    gtk_table_attach( GTK_TABLE(table2),label,0,1,2,3,0,0,0,5);
	gtk_table_attach( GTK_TABLE(table2),button,1,2,2,3,0,0,0,5 );*/

	label = gtk_label_new("Visual");
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), vbox,label);
	gtk_widget_show(frame);
	
	button = create_button("OK",cb_prefs_ok,NULL);
	gtk_table_attach(GTK_TABLE(table), button,
								0,1,2,3,
								GTK_FILL,GTK_FILL,0,5);
	gtk_widget_grab_default(GTK_WIDGET(button));
	button = create_button("Apply",cb_prefs_apply,NULL);
	gtk_table_attach(GTK_TABLE(table), button,
								1,2,2,3,
								GTK_FILL,GTK_FILL,0,5);
	button = create_button("Cancel",close_prefs_window,NULL);
	gtk_table_attach(GTK_TABLE(table), button, 
								2,3,2,3,
								GTK_FILL,GTK_FILL,0,5);
	
    gtk_notebook_set_page(GTK_NOTEBOOK(notebook),def);
	gtk_window_set_position (GTK_WINDOW (pref_window), GTK_WIN_POS_CENTER);
	gtk_widget_show(pref_window);
	gtk_window_set_transient_for (GTK_WINDOW (pref_window),GTK_WINDOW (app.main_window));
    gtk_grab_add(pref_window);
}

void cb_color_dialog_show(GtkWidget *widget, GdkColor *color)
{
	gdouble rgb[3];

	rgb[0] = color->red / 65535.0;
  	rgb[1] = color->green / 65535.0;
  	rgb[2] = color->blue / 65535.0;

	colorseldlg = gtk_color_selection_dialog_new("Select background color");
	gtk_color_selection_set_color (GTK_COLOR_SELECTION
				 (GTK_COLOR_SELECTION_DIALOG(colorseldlg)->colorsel), rgb);
   	gtk_signal_connect(GTK_OBJECT(GTK_COLOR_SELECTION_DIALOG(colorseldlg)->colorsel), "color_changed",
						(GtkSignalFunc)cb_colorsel_color_change, widget);
	gtk_signal_connect(GTK_OBJECT(GTK_COLOR_SELECTION_DIALOG(colorseldlg)->ok_button),"clicked",
									GTK_SIGNAL_FUNC(cb_color_sel_ok),color);
	gtk_signal_connect(GTK_OBJECT(GTK_COLOR_SELECTION_DIALOG(colorseldlg)->cancel_button),"clicked",
									GTK_SIGNAL_FUNC(cb_color_sel_cancel),&color);
    gtk_widget_show(colorseldlg);
	gtk_grab_add(colorseldlg);
	gtk_window_set_transient_for (GTK_WINDOW (colorseldlg),
				GTK_WINDOW (app.main_window));
}

void cb_colorsel_color_change(GtkWidget *widget, GtkWidget *button)
{
	GdkColor color;
  	gdouble rgb[3];
  	GtkStyle *style = gtk_style_new ();

  	gtk_color_selection_get_color (GTK_COLOR_SELECTION (widget), rgb);

  	color.red = rgb[0] * 65535.0;
  	color.green = rgb[1] * 65535.0;
  	color.blue = rgb[2] * 65535.0;

  	style->bg[GTK_STATE_NORMAL] = color;
  	gtk_widget_set_style (button, style);
}

void cb_color_sel_ok(GtkWidget *widget, GdkColor *color)
{
	gdouble rgb[3];

	gtk_color_selection_get_color (GTK_COLOR_SELECTION(GTK_COLOR_SELECTION_DIALOG
									(colorseldlg)->colorsel), rgb);
	color->red = rgb[0] * 65535.0;
  	color->green = rgb[1] * 65535.0;
  	color->blue = rgb[2] * 65535.0;

  	gtk_grab_remove (colorseldlg);
  	gtk_widget_destroy (colorseldlg);
}

void cb_color_sel_cancel (GtkWidget * button)
{
  	gtk_grab_remove (colorseldlg);
  	gtk_widget_destroy (colorseldlg);
}

