/* Linux Commander
 * Copyright (C) 2000 Per Holmng.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "linuxcmd.h"

GtkWidget *mount_window;
GtkWidget *entry_dev;
GtkWidget *entry_type;
GtkWidget *entry_mpoint;
GtkWidget *chk_gonow;

void cb_mount_ok();
void cb_mount_cancel();
void create_mount_window();
void mount(gchar *dev, gchar *type, gchar *mpoint);

void cb_mount_ok()
{
    gchar *buf1,*buf2,*buf3;
    gint gothere;
    
    gothere = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(chk_gonow));
    buf1 = gtk_entry_get_text(GTK_ENTRY(entry_dev));
    buf2 = gtk_entry_get_text(GTK_ENTRY(entry_type));
    buf3 = gtk_entry_get_text(GTK_ENTRY(entry_mpoint));
    mount(buf1,buf2,buf3);
    if (gothere == 1)
        update_filelist(buf3,focused);
    gtk_grab_remove(mount_window);
    gtk_widget_destroy(mount_window);
    gtk_main_quit();
}

void cb_mount_cancel()
{
    gtk_grab_remove(mount_window);
    gtk_widget_destroy(mount_window);
    gtk_main_quit();
}

void create_mount_window()
{
    GtkWidget *label;
	GtkWidget *button;
	GtkWidget *frame;
	GtkWidget *table;
	GtkWidget *hbox,*vbox;
	GList *fstypes = NULL;
	gint policy[3] = {0,1,1};
    FILE *fp;
    gchar buf[256];
    gchar *strip;
    
	mount_window = create_window("Mount",400,170,policy);
	gtk_signal_connect(GTK_OBJECT(mount_window),"delete-event",
						GTK_SIGNAL_FUNC(cb_delete_event),NULL);
	gtk_container_set_border_width(GTK_CONTAINER(mount_window),5);
	
	vbox = gtk_vbox_new(FALSE,5);
	gtk_container_add(GTK_CONTAINER(mount_window),vbox);
	gtk_widget_show(vbox);

	frame = gtk_frame_new(0);
	gtk_box_pack_start(GTK_BOX(vbox),frame,0,0,5);
	gtk_widget_show(frame);
	
	table = gtk_table_new(4,3,FALSE);
	gtk_container_set_border_width(GTK_CONTAINER(table),5);
	gtk_container_add(GTK_CONTAINER(frame),table);
	gtk_widget_show(table);
	
	label = gtk_label_new("Device: ");
	gtk_label_set_justify(GTK_LABEL(label),GTK_JUSTIFY_RIGHT);
	gtk_table_attach(GTK_TABLE(table),label,0,1,0,1,GTK_FILL,0,5,0);
	gtk_widget_show(label);

	entry_dev = create_entry("",0,NULL,NULL);
	gtk_table_attach(GTK_TABLE(table),entry_dev,1,2,0,1,GTK_FILL | GTK_EXPAND,0,5,0);

    button = create_browse_button(cb_browsedir,entry_dev);
    gtk_table_attach(GTK_TABLE(table),button,2,3,0,1,GTK_FILL,0,5,0);
    
	label = gtk_label_new("Filesys type: ");
	gtk_label_set_justify(GTK_LABEL(label),GTK_JUSTIFY_LEFT);
	gtk_table_attach(GTK_TABLE(table),label,0,1,1,2,GTK_FILL,1,5,0);
	gtk_widget_show(label);
    
    entry_type = gtk_combo_new();
    if ((fp = fopen(get_fstypes_filename(),"r")))
    {
    	while (fgets(buf,256,fp))
	    {
    		if ((strip = (char *)strchr(buf,'\n')))
	    		*strip = 0;
            if (strlen(buf) > 0)            
                fstypes = g_list_append(fstypes,g_strdup(buf));
        }
    }
    
	gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(entry_type)->entry),1);
	gtk_table_attach(GTK_TABLE(table),entry_type,1,2,1,2,GTK_FILL | GTK_EXPAND,0,5,0);
    if (fstypes)
        gtk_combo_set_popdown_strings(GTK_COMBO(entry_type),fstypes);
    gtk_widget_show(entry_type);

	label = gtk_label_new("Mount point: ");
	gtk_label_set_justify(GTK_LABEL(label),GTK_JUSTIFY_LEFT);
	gtk_table_attach(GTK_TABLE(table),label,0,1,2,3,GTK_FILL,1,5,0);
	gtk_widget_show(label);

	entry_mpoint = create_entry("",0,NULL,NULL);
	gtk_table_attach(GTK_TABLE(table),entry_mpoint,1,2,2,3,GTK_FILL | GTK_EXPAND,0,5,0);
	
    button = create_browse_button(cb_browsedir,entry_mpoint);
    gtk_table_attach(GTK_TABLE(table),button,2,3,2,3,GTK_FILL,0,5,0);
    
	chk_gonow = gtk_check_button_new_with_label("Go there now?");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chk_gonow),0);
	gtk_table_attach(GTK_TABLE(table),chk_gonow,0,2,3,4,GTK_FILL | GTK_EXPAND,0,5,5);
	gtk_widget_show(chk_gonow);
		
	hbox = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,0,0,0);
	gtk_widget_show(hbox);

	button = create_button("OK",cb_mount_ok,NULL);
	gtk_box_pack_end(GTK_BOX(hbox),button,1,1,5);
	gtk_widget_grab_default(GTK_WIDGET(button));
	button = create_button("Cancel",cb_mount_cancel,NULL);
	gtk_box_pack_end(GTK_BOX(hbox),button,1,1,5);
	
	gtk_window_set_position (GTK_WINDOW (mount_window), GTK_WIN_POS_CENTER);
	gtk_widget_show(mount_window);
	gtk_window_set_transient_for (GTK_WINDOW (mount_window),GTK_WINDOW (app.main_window));
	gtk_grab_add(mount_window);
    gtk_widget_grab_focus(entry_dev);

}

void mount(gchar *dev, gchar *type, gchar *mpoint)
{
    gchar *buf[6];
    
    buf[0] = "mount";
    buf[1] = "-t";
    buf[2] = type;
    buf[3] = dev;
    buf[4] = mpoint;
    buf[5] = NULL;

    execute_cmd(buf);
}

