/* Linux Commander
 * Copyright (C) 2000 Per Holmng.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "linuxcmd.h"
#define FUNCTIONS 8

GtkWidget *func_window;
GtkWidget *clist;
gint func_selectedrow = -1;

void cb_insert_function(GtkWidget *wid, GtkWidget *entry,gint row)
{
    gchar *buf;
    gtk_clist_get_text(GTK_CLIST(clist),row,0,&buf);
    gtk_entry_append_text(GTK_ENTRY(entry),buf);
    gtk_grab_remove(func_window);
    gtk_widget_destroy(func_window);
}


void cb_func_doubleclick(GtkWidget *wid, gint row,gint column,GdkEvent *event, GtkWidget *entry)
{
	if (event)
	{
		if (event->type == GDK_2BUTTON_PRESS)
		{
			cb_insert_function(wid,entry,row);            
		}
	}
}

void create_functions_dialog(GtkWidget *wid, GtkWidget *entry)
{
    GtkWidget *vbox;
    GtkWidget *hbox;
    GtkWidget *scrolled_window;
    gchar *functions[FUNCTIONS][2] = {
                                     { "%a","All selected files" },
                                     { "%f","Prompt for filename" },
                                     { "%d","Prompt for directory" },
                                     { "%y","Prompt for a value" },
                                     { "%1","Selected file" },
                                     { "%v","Working dir of focused filelist" },
                                     { "%w","Working dir of opposite filelist" },
                                     { "%x","Your xterm command" },
                                     };
    gint policy[3] = {1,1,1};
    gint a;
    gchar *titles[2] = { "Command","Description" };
    func_window = create_window("Choose function",400,400,policy);

    vbox = gtk_vbox_new(FALSE,5);
    gtk_container_add(GTK_CONTAINER(func_window),vbox);
    gtk_widget_show(vbox);
    
    scrolled_window = gtk_scrolled_window_new(NULL,NULL);
	gtk_container_set_border_width(GTK_CONTAINER(scrolled_window),5);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
                                    GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start(GTK_BOX(vbox),scrolled_window,1,1,0);
	gtk_widget_show(scrolled_window);
	
	clist = gtk_clist_new_with_titles(2,titles);
	gtk_signal_connect(GTK_OBJECT(clist),"select-row",cb_func_doubleclick,entry);
    /*gtk_signal_connect(GTK_OBJECT(ass_clist),"unselect-row",cb_ass_clist_unselect_row,NULL);*/
	gtk_container_add(GTK_CONTAINER(scrolled_window), clist);	
    for (a = 0; a < FUNCTIONS; a++)
    {
        gtk_clist_append(GTK_CLIST(clist),functions[a]);
    }    
    gtk_widget_show(clist);    

    gtk_window_set_position (GTK_WINDOW (func_window), GTK_WIN_POS_MOUSE);
	gtk_widget_show(func_window);
	gtk_window_set_transient_for (GTK_WINDOW (func_window),GTK_WINDOW (app.main_window));
	gtk_grab_add(func_window);
}
