/* Linux Commander
 * Copyright (C) 2000 Per Holmng.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "linuxcmd.h"

gboolean continue_read = TRUE;
GtkWidget *fileview_window;

void create_fileview_window(gchar *filename);
gint read_file(GtkWidget *text,gchar *filename);
void fileview_mscroll(GtkWidget *text,gint direction);
void cb_fileview_mouseevent(GtkWidget *wid, GdkEventButton *event, gpointer data);


void create_fileview_window(gchar *filename)
{
    GtkWidget *table;
    GtkWidget *vsb;
    GtkWidget *text;
    gint policy[3] = {1,1,1};
    GtkWidget *vbox1;
    GtkWidget *vbox2;

    fileview_window = create_window(filename,650,550,policy);
    
    vbox1 = gtk_vbox_new(TRUE, TRUE);
    gtk_container_add(GTK_CONTAINER(fileview_window),vbox1);
	gtk_widget_show(vbox1);

	table = gtk_table_new(2, 1, FALSE);
	gtk_box_pack_start(GTK_BOX(vbox1), table, TRUE, TRUE, 1);
	gtk_widget_show(table);

    text = gtk_text_new (NULL, NULL);
    gtk_signal_connect(GTK_OBJECT(text), "button_press_event", GTK_SIGNAL_FUNC(cb_fileview_mouseevent), NULL);
    gtk_text_set_editable (GTK_TEXT (text), FALSE);
    gtk_table_attach_defaults(GTK_TABLE(table), text, 0, 1, 0, 1);
    gtk_widget_show (text);

    vbox2 = gtk_vbox_new(TRUE, TRUE);
	gtk_widget_show(vbox2);

	vsb = gtk_vscrollbar_new(GTK_TEXT(text)->vadj);
	gtk_box_pack_start(GTK_BOX(vbox2), vsb, TRUE, TRUE, 0);
	gtk_table_attach(GTK_TABLE(table), vbox2, 1, 2, 0, 1,
				 GTK_FILL, GTK_EXPAND | GTK_FILL,0, 0);
    GTK_WIDGET_UNSET_FLAGS(vsb, GTK_CAN_FOCUS);
    gtk_widget_show(vsb);

    read_file(text,filename);

    gtk_window_set_position (GTK_WINDOW (fileview_window), GTK_WIN_POS_CENTER);
    gtk_widget_show(fileview_window);

}

gint read_file(GtkWidget *text,gchar *filename)
{
    FILE *fp;
    size_t size;
	off_t bytesread;
	char *buf;
    long num;
    struct stat tmp;

    stat(filename,&tmp);
    fp = fopen(filename,"r");
    if (fp == NULL)
		return -1;
    size = (size_t)BUFSIZ;
	buf = g_new(char, size + 1);
    bytesread = 0;
    
    while (bytesread < tmp.st_size) 
    {
		while (gtk_events_pending())
                gtk_main_iteration();
    	num = fread(buf, 1, size, fp);
		if (num > 0) 
        {
			if (GTK_IS_TEXT(text))
				gtk_text_insert(GTK_TEXT(text), NULL,NULL,NULL, buf, num);                        
            bytesread += num;
        }
    }   
}

void fileview_mscroll(GtkWidget *text,gint direction)
{
    float val;
    GtkAdjustment *adj;

    adj = GTK_ADJUSTMENT(GTK_TEXT(text)->vadj);
    if (direction == 1)
        val = adj->value - (adj->page_increment / 2);
    else
        val = adj->value + (adj->page_increment / 2);
    gtk_adjustment_set_value(adj, val);
}

void cb_fileview_mouseevent(GtkWidget *wid, GdkEventButton *event, gpointer data)
{
    switch (event->button) 
    {
        case 4:
            fileview_mscroll(wid, 1);
            break;
        case 5:
            fileview_mscroll(wid, 2);
            break;
        default:
            break;
    }
}


