/* Linux Commander
 * win.ight (C) 2000 Per Holmng.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a win.of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "linuxcmd.h"


FileOpsWindow win;

void cb_fileops_cancel()
{
	win.cancel = 1;
}

void destroy_fileops_window()
{
	gtk_widget_hide(win.window);
}

void create_fileops_window( gchar *title )
{
	gint policy[3] = {1,1,1}; 
	win.cancel = 0;
	win.window = create_window(title,500,100,policy);
	gtk_container_set_border_width(GTK_CONTAINER(win.window),5);
	win.table = gtk_table_new(4,1,FALSE);
	gtk_container_add(GTK_CONTAINER(win.window),win.table);
	win.label = gtk_label_new("");
	gtk_table_attach_defaults(GTK_TABLE(win.table),win.label,0,1,0,1);
	gtk_widget_show(win.label);
	gtk_widget_show(win.table);
	gtk_window_set_position (GTK_WINDOW (win.window), GTK_WIN_POS_CENTER);
	gtk_window_set_transient_for (GTK_WINDOW (win.window),GTK_WINDOW (app.main_window));
}

void create_fileops_sum_pbar( int val )
{
	GtkAdjustment *adj;
	
	adj = (GtkAdjustment *) gtk_adjustment_new (0, 0, val, 0, 0, 0);
	win.sumpbar = gtk_progress_bar_new_with_adjustment (adj);
	gtk_progress_set_format_string (GTK_PROGRESS (win.sumpbar),"%p%%");
	gtk_progress_set_show_text (GTK_PROGRESS (win.sumpbar),1);
	gtk_progress_bar_set_bar_style (GTK_PROGRESS_BAR (win.sumpbar),GTK_PROGRESS_CONTINUOUS);
	gtk_table_attach_defaults(GTK_TABLE(win.table),win.sumpbar,0,1,1,2);
	gtk_widget_show(win.sumpbar);
}

void create_fileops_pbar( int val, const gchar *filename )
{
	GtkAdjustment *adj;
	GtkWidget *btn = NULL;
	
	adj = (GtkAdjustment *) gtk_adjustment_new (0, 1, val, 0, 0, 0);
	gtk_label_set_text(GTK_LABEL(win.label),filename);
	win.pbar = gtk_progress_bar_new_with_adjustment (adj);
	gtk_progress_set_format_string (GTK_PROGRESS (win.pbar),"%p%%");
	gtk_progress_set_show_text (GTK_PROGRESS (win.pbar),1);
	gtk_progress_bar_set_bar_style (GTK_PROGRESS_BAR (win.pbar),GTK_PROGRESS_CONTINUOUS);
	gtk_table_attach_defaults(GTK_TABLE(win.table),win.pbar,0,1,2,3);
	gtk_widget_show(win.pbar);

	btn = create_button("Cancel",cb_fileops_cancel,NULL);
	gtk_table_attach_defaults(GTK_TABLE(win.table),btn,0,1,3,4);

	gtk_widget_show(win.window);
}


