/* Linux Commander
 * Copyright (C) 2000 Per Holmng.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "linuxcmd.h"

GtkWidget *df_window;
GtkWidget *clist;

void close_df_window()
{
	gtk_grab_remove(df_window);
	gtk_widget_destroy(df_window);
	gtk_main_quit();
}

void cb_diskfree()
{
	FILE *fp;
	gchar *strip;
	gchar buf[256];
	gint policy[3] = {0,1,1};
	gchar *titles[6] = {"Filesystem","Size","Used","Avail","Use%","Mountpoint"};
	gchar *row[6];
	GtkWidget *scrollwin;
	
	df_window = create_window("Info - Filesystems",440,200,policy);
	gtk_signal_connect(GTK_OBJECT(df_window),"delete-event",
						GTK_SIGNAL_FUNC(close_df_window),NULL);
	
	gtk_container_set_border_width(GTK_CONTAINER(df_window),5);
	scrollwin = gtk_scrolled_window_new(NULL,NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrollwin),GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
	gtk_container_add(GTK_CONTAINER(df_window),scrollwin);
	gtk_widget_show(scrollwin);

	clist = gtk_clist_new_with_titles(6,titles);
	gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrollwin),clist);
	gtk_widget_show(clist);

	gtk_clist_freeze(GTK_CLIST(clist));

	if ((fp = popen("df -h","r")) == NULL)
	{
		return;
	}
	while ((fgets(buf,256,fp)))
	{
		if ((strip = strchr(buf,'\n')))
			*strip = 0;
		if (buf[0] == '/')
		{
			row[0] = strtok(buf," ");
			row[1] = strtok(NULL," ");
			row[2] = strtok(NULL," ");
			row[3] = strtok(NULL," ");
			row[4] = strtok(NULL," ");
			row[5] = strtok(NULL," ");
			gtk_clist_append(GTK_CLIST(clist),row);
		}	
	}
	gtk_clist_set_column_width(GTK_CLIST(clist),0,gtk_clist_optimal_column_width(GTK_CLIST(clist),0)+20);
	gtk_clist_set_column_width(GTK_CLIST(clist),1,gtk_clist_optimal_column_width(GTK_CLIST(clist),1)+20);
	gtk_clist_set_column_width(GTK_CLIST(clist),2,gtk_clist_optimal_column_width(GTK_CLIST(clist),2)+20);
	gtk_clist_set_column_width(GTK_CLIST(clist),3,gtk_clist_optimal_column_width(GTK_CLIST(clist),3)+20);
	gtk_clist_set_column_width(GTK_CLIST(clist),4,gtk_clist_optimal_column_width(GTK_CLIST(clist),4)+20);
	gtk_clist_set_column_width(GTK_CLIST(clist),5,gtk_clist_optimal_column_width(GTK_CLIST(clist),5));
	gtk_clist_thaw(GTK_CLIST(clist));
	
	gtk_window_set_position (GTK_WINDOW (df_window), GTK_WIN_POS_CENTER);
	gtk_widget_show(df_window);
	gtk_window_set_transient_for (GTK_WINDOW (df_window),GTK_WINDOW (app.main_window));
	gtk_grab_add(df_window);
	gtk_main();
}
