/* Linux Commander
 * Copyright (C) 2000 Per Holmng.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "linuxcmd.h"

#include "folder.xpm"

GtkWidget *window;
GtkWidget *tree;

typedef struct
{
	gboolean scanned;
	gchar *path;
}
TreeNode;

static GdkPixmap *folder_pixmap = NULL;
static GdkBitmap *folder_mask;

void cb_dirbrowse_ok(GtkWidget *wid, gchar ** dir)
{
    GList *nodes;
    TreeNode *buf;
    GtkCTreeNode *node;
    
    nodes = GTK_CLIST(tree)->selection;
    while (nodes)
    {
        node = nodes->data;
        buf = gtk_ctree_node_get_row_data(GTK_CTREE(tree), node);
        *dir = g_strdup(buf->path);
        nodes = g_list_next(nodes);
        gtk_grab_remove (window);
        gtk_widget_destroy(window);
        gtk_main_quit();
    }
}

void cb_dirbrowse_cancel(GtkWidget *wid,gchar ** dir)
{ 
    *dir = NULL;
    gtk_grab_remove (window);
    gtk_widget_destroy(window);
    gtk_main_quit();
}

gboolean check_subdir(gchar *path)
{
    DIR *dh;
    struct dirent *dp; 
    struct stat statbuf;
    gchar *tmp;
    
    if (dh = opendir(path))
    {
        while ((dp = readdir (dh)) != NULL)
        {
            if (strcmp(dp->d_name,".") != 0 && strcmp(dp->d_name,"..") != 0)
            {
                tmp = malloc(strlen(path)+strlen(dp->d_name)+3);
                sprintf(tmp,"%s/%s",path,dp->d_name);
                stat(tmp,&statbuf);
                if (S_ISDIR(statbuf.st_mode))
                    return TRUE;
            }
        }
        closedir(dh);
    }
    return FALSE;

}

void cb_tree_select_row(GtkWidget *tree, gint row,gint column,
						GdkEvent *event, gchar ** dir)
{
    GtkCTreeNode *node;

	if (event)
    {
		if(event->type == GDK_2BUTTON_PRESS)
		{
            GList *nodes;
            TreeNode *buf;
    
            nodes = GTK_CLIST(tree)->selection;
            while (nodes)
        	{
        		node = nodes->data;
        		buf = gtk_ctree_node_get_row_data(GTK_CTREE(tree), node);
                *dir = g_strdup(buf->path);
        		nodes = g_list_next(nodes);
                gtk_grab_remove (window);
                gtk_widget_destroy(window);
                gtk_main_quit();
        	}
		}
	}
}

void cb_tree_expand(GtkWidget *wid,GtkCTreeNode *parent_node)
{
    DIR *dh;
    struct dirent *dp;
    struct stat statbuf;
    gchar *tmp;
    gchar *dir;
    gchar *dummy = "dummy";
    GtkCTreeNode *par;
    GtkCTreeNode *node;
    TreeNode *parent_treenode, *treenode;
    gboolean has_subdir = FALSE;

    parent_treenode = gtk_ctree_node_get_row_data(GTK_CTREE(wid), parent_node);
    
    if (!parent_treenode->scanned)
    {    
        gtk_clist_freeze(GTK_CLIST(wid));

        node = gtk_ctree_find_by_row_data(GTK_CTREE(wid), parent_node, NULL);
		gtk_ctree_remove_node(GTK_CTREE(wid), node);
        if (dh = opendir(parent_treenode->path))
        {
            while ((dp = readdir (dh)) != NULL)
            {           
                if (strcmp(dp->d_name,".") != 0 && strcmp(dp->d_name,"..") != 0)
                {
                    treenode = g_malloc0(sizeof (TreeNode));
                    tmp = malloc(strlen(parent_treenode->path)+strlen(dp->d_name)+3);
                    if (strcmp(parent_treenode->path,"/") == 0)
                        sprintf(tmp,"/%s",dp->d_name);
                    else
                        sprintf(tmp,"%s/%s",parent_treenode->path,dp->d_name);
                    treenode->path = tmp;
                    stat(tmp,&statbuf);
                    dir = dp->d_name;
                    if (S_ISDIR (statbuf.st_mode))
                    {
                        if (check_subdir(tmp))
                            has_subdir = TRUE;
                        else
                            has_subdir = FALSE;

                        node = gtk_ctree_insert_node(GTK_CTREE(wid),parent_node,NULL,&dir,2,folder_pixmap,folder_mask,folder_pixmap,folder_mask,!has_subdir,0);
                        gtk_ctree_node_set_row_data_full(GTK_CTREE(wid), node, treenode, NULL);
                        if (check_subdir(tmp) == TRUE)                
                            gtk_ctree_insert_node(GTK_CTREE(wid),node,NULL,&dummy,2,NULL,NULL,NULL,NULL,0,0);
                    }
                }
            }
        }
        gtk_clist_thaw(GTK_CLIST(wid));
        parent_treenode->scanned = TRUE;
    }

}

void create_dirbrowse_window(gchar ** dir)
{
    GtkWidget *vbox,*hbox;
    GtkWidget *scrolledwin;
    GtkWidget *button;
    GtkCTreeNode *root;
    gchar *root_txt = "/";
    gchar *node_txt = "dummy";
    TreeNode *treenode;
    gint policy[3] = { 1,1,1 }; 

    folder_pixmap = gdk_pixmap_create_from_xpm_d(app.main_window->window, &folder_mask, NULL, folder_xpm);
    
    window = create_window ("Select directory",400,370,policy);
    gtk_container_set_border_width(GTK_CONTAINER(window),5);
    
    vbox = gtk_vbox_new(FALSE,5);
    gtk_container_add(GTK_CONTAINER(window),vbox);
    gtk_widget_show(vbox);
    
    scrolledwin = gtk_scrolled_window_new(NULL,NULL);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwin),GTK_POLICY_AUTOMATIC,  GTK_POLICY_AUTOMATIC);
    gtk_box_pack_start(GTK_BOX(vbox),scrolledwin,1,1,0);
    gtk_widget_show(scrolledwin);
    
    tree = gtk_ctree_new(1,0);
    gtk_clist_set_column_auto_resize(GTK_CLIST(tree), 0, TRUE);
    gtk_ctree_set_line_style(GTK_CTREE(tree), GTK_CTREE_LINES_DOTTED);
    gtk_signal_connect(GTK_OBJECT(tree),"tree_expand",cb_tree_expand,NULL);
    gtk_signal_connect(GTK_OBJECT(tree),"select-row",cb_tree_select_row,dir);
    gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW(scrolledwin), tree);
    gtk_widget_show(tree);

    hbox = gtk_hbox_new(FALSE,0);
    gtk_box_pack_start(GTK_BOX(vbox),hbox,0,0,5);
    gtk_widget_show(hbox);

    button = create_button("OK",cb_dirbrowse_ok,dir);
    gtk_box_pack_start(GTK_BOX(hbox),button,1,1,0);
    button = create_button("Cancel",cb_dirbrowse_cancel,dir);
    gtk_box_pack_start(GTK_BOX(hbox),button,1,1,0);

    treenode = g_malloc0(sizeof (TreeNode));
	treenode->path = g_strdup("/");
    root = gtk_ctree_insert_node(GTK_CTREE(tree),NULL,NULL,&root_txt,2,folder_pixmap,folder_mask,folder_pixmap,folder_mask,0,0);
    gtk_ctree_node_set_row_data_full(GTK_CTREE(tree), root, treenode, NULL);
    gtk_ctree_insert_node(GTK_CTREE(tree),root,NULL,&node_txt,2,NULL,NULL,NULL,NULL,0,0);
    gtk_ctree_expand(GTK_CTREE(tree), root);

    gtk_window_set_position(GTK_WINDOW(window),GTK_WIN_POS_CENTER);
    gtk_widget_show(window);
    gtk_grab_add(window);
	gtk_window_set_transient_for (GTK_WINDOW (window),GTK_WINDOW (app.main_window));
}
