/* Linux Commander
 * Copyright (C) 2000 Per Holmng.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "linuxcmd.h"

GtkWidget *entry;
GtkWidget *window;

void cb_ok(GtkWidget * widget, gint ** button)
{
	(gint)*button = 1;
	gtk_grab_remove (window);
  	gtk_widget_destroy (window);
	gtk_main_quit();
}

void cb_entry_dialog_keypress(GtkWidget *widget, GdkEventKey *event, gchar ** string)
{	
	if (event->keyval == GDK_Escape)
	{
    	cb_entry_cancel(widget,string);
	}
}

void cb_dialog_keypress(GtkWidget *widget, GdkEventKey *event, gint ** button)
{	
	if (event->keyval == GDK_Escape)
	{
    	cb_cancel(widget,button);
	}
}

void cb_cancel(GtkWidget * widget, gint ** button)
{
	if (button != NULL)
	{
		*button = 0;
	}
	gtk_grab_remove (window);
  	gtk_widget_destroy (window);
	gtk_main_quit ();
}

void cb_entry_ok(GtkWidget *widget, gchar ** string)
{
	gchar *s;

  	s = gtk_entry_get_text (GTK_ENTRY (entry));
  	if (strlen (s) == 0)
    {
      	statusbar_print("What are you trying to do?");
      	return;
    }

  	*string = g_strdup (s);

  	gtk_grab_remove (window);
  	gtk_widget_destroy (window);
  	gtk_main_quit ();
}

void cb_entry_cancel (GtkWidget * widget, gchar ** string)
{
  *string = NULL;
  gtk_grab_remove (window);
  gtk_widget_destroy (window);
  gtk_main_quit ();
}

void create_dialog_with_entry(gchar *title, gchar *entry_title, gchar *entry_txt, gchar ** string)
{
	GtkWidget *button;
	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *frame;
	gint policy[3] = {1,0,1};
	
	window = create_window(title,400,105,policy);
	gtk_container_set_border_width(GTK_CONTAINER(window),5);
	gtk_signal_connect (GTK_OBJECT (window), "key_press_event", 
						cb_entry_dialog_keypress,string);
	gtk_signal_connect (GTK_OBJECT (window), "delete_event", cb_delete_event,NULL);

	vbox = gtk_vbox_new(FALSE,5);
	gtk_container_add(GTK_CONTAINER(window),vbox);
	gtk_widget_show(vbox);

	frame = gtk_frame_new(entry_title);
	gtk_widget_set_usize(GTK_WIDGET(frame),350,55);
	gtk_box_pack_start(GTK_BOX(vbox),frame,0,0,0);
	gtk_widget_show(frame);

	hbox = gtk_hbox_new(FALSE,5);
	gtk_container_add(GTK_CONTAINER(frame),hbox);
	gtk_widget_show(hbox);

	entry = create_entry(entry_txt,0,cb_entry_ok,string);
	gtk_signal_connect (GTK_OBJECT (entry), "key_press_event", 
						cb_dialog_keypress,string);
	gtk_widget_set_usize(GTK_WIDGET(entry),375,20);
	gtk_box_pack_start(GTK_BOX(hbox),entry,0,0,5);
	
	hbox = gtk_hbox_new(FALSE,5);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);
	gtk_widget_show(hbox);

	button = create_button("Cancel",cb_entry_cancel,string);
	gtk_box_pack_end(GTK_BOX(hbox),button,1,1,0);

	button = create_button("OK",cb_entry_ok,string);
	gtk_box_pack_end(GTK_BOX(hbox),button,1,1,0);
	gtk_widget_grab_default(GTK_WIDGET(button));
	
	gtk_window_set_position (GTK_WINDOW (window), GTK_WIN_POS_CENTER);
	gtk_widget_show(window);
	gtk_grab_add(window);
	gtk_window_set_transient_for (GTK_WINDOW (window),GTK_WINDOW (app.main_window));
	gtk_widget_grab_focus(entry);
}

void cb_delete_event (GtkWidget * widget)
{
}

void create_dialog(gchar *title, gchar *frame_title,gchar *text, gint height, gint **button)
{
	GtkWidget *buttons;
	GtkWidget *label;
	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *frame;
	GtkWidget *scrolledwindow;
	gint policy[3] = {0,1,1};
	
	window = create_window(title,400,height+10,policy);
	gtk_container_set_border_width(GTK_CONTAINER(window),5);
	gtk_signal_connect (GTK_OBJECT (window), "delete_event", 
    					cb_delete_event,NULL);
    gtk_signal_connect (GTK_OBJECT (window), "key_press_event", 
						cb_dialog_keypress,button);

	vbox = gtk_vbox_new(FALSE,5);
	gtk_container_add(GTK_CONTAINER(window),vbox);
	gtk_widget_show(vbox);

	frame = gtk_frame_new(0);
	gtk_widget_set_usize(GTK_WIDGET(frame),350,height-40);
	gtk_box_pack_start(GTK_BOX(vbox),frame,1,1,0);
	gtk_widget_show(frame);

	hbox = gtk_hbox_new(FALSE,5);
	gtk_container_add(GTK_CONTAINER(frame),hbox);
	gtk_widget_show(hbox);
    
	label = gtk_label_new(text);
	gtk_label_set_justify(GTK_LABEL(label),GTK_JUSTIFY_LEFT);
	gtk_label_set_line_wrap (GTK_LABEL(label),1);
	scrolledwindow = gtk_scrolled_window_new(NULL,NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolledwindow),
								   GTK_POLICY_AUTOMATIC,
								   GTK_POLICY_AUTOMATIC);
	gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolledwindow),label);
	gtk_container_set_border_width(GTK_CONTAINER(scrolledwindow),5);
	gtk_box_pack_start(GTK_BOX(hbox),scrolledwindow,1,1,5);
	gtk_widget_show(label);
	gtk_widget_show(scrolledwindow);
	
	hbox = gtk_hbox_new(FALSE,5);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,0,0,0);
	gtk_widget_show(hbox);
	
	buttons = create_button("No",cb_cancel,button);
	gtk_box_pack_end(GTK_BOX(hbox),buttons,1,1,0);

	buttons = create_button("Yes",cb_ok,button);
	gtk_box_pack_end(GTK_BOX(hbox),buttons,1,1,0);
	gtk_widget_grab_default(GTK_WIDGET(buttons));

	gtk_window_set_position (GTK_WINDOW (window), GTK_WIN_POS_CENTER);
	gtk_widget_show(window);
	gtk_grab_add(window);
	gtk_window_set_transient_for (GTK_WINDOW (window),GTK_WINDOW (app.main_window));
	gtk_widget_grab_focus(buttons);
}

void create_dialog_ok_only(gchar *title,gchar *frame_title,gint height, gchar *text)
{
	GtkWidget *button;
	GtkWidget *label;
	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *frame;
	GtkWidget *scrolledwindow;

	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_policy(GTK_WINDOW(window),0,0,0);
	gtk_container_set_border_width(GTK_CONTAINER(window),5);
	gtk_widget_set_usize(GTK_WIDGET(window),400,height+10);
	gtk_window_set_title(GTK_WINDOW(window),title);
	gtk_signal_connect (GTK_OBJECT (window), "delete_event", 
						cb_delete_event,NULL);
    gtk_signal_connect (GTK_OBJECT (window), "key_press_event", 
						cb_dialog_keypress,NULL);

	vbox = gtk_vbox_new(FALSE,5);
	gtk_container_add(GTK_CONTAINER(window),vbox);
	gtk_widget_show(vbox);

	frame = gtk_frame_new(0);
	gtk_widget_set_usize(GTK_WIDGET(frame),350,height-40);
	gtk_box_pack_start(GTK_BOX(vbox),frame,0,0,0);
	gtk_widget_show(frame);

	hbox = gtk_hbox_new(FALSE,5);
	gtk_container_add(GTK_CONTAINER(frame),hbox);
	gtk_widget_show(hbox);
	
	label = gtk_label_new(text);
	gtk_label_set_justify(GTK_LABEL(label),GTK_JUSTIFY_LEFT);
	gtk_label_set_line_wrap (GTK_LABEL(label),1);
	scrolledwindow = gtk_scrolled_window_new(NULL,NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolledwindow),
								   GTK_POLICY_AUTOMATIC,
								   GTK_POLICY_AUTOMATIC);
	gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolledwindow),label);
	gtk_container_set_border_width(GTK_CONTAINER(scrolledwindow),5);
	gtk_box_pack_start(GTK_BOX(hbox),scrolledwindow,1,1,5);
	gtk_widget_show(label);
	gtk_widget_show(scrolledwindow);

	hbox = gtk_hbox_new(FALSE,5);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);
	gtk_widget_show(hbox);
	
	button = create_button("OK",cb_cancel,NULL);
	gtk_box_pack_end(GTK_BOX(hbox),button,1,1,0);
	gtk_widget_grab_default(GTK_WIDGET(button));
	
	gtk_window_set_position (GTK_WINDOW (window), GTK_WIN_POS_CENTER);
	gtk_widget_show(window);
	gtk_grab_add(window);
	gtk_window_set_transient_for (GTK_WINDOW (window),GTK_WINDOW (app.main_window));
	gtk_widget_grab_focus(button);
}


void file_sel_cancel( GtkWidget *w, gchar ** filename )
{
    *filename = NULL;
    gtk_grab_remove(w->parent->parent->parent);
    gtk_widget_destroy(w->parent->parent->parent);
    gtk_main_quit();
}

void file_sel_ok( GtkWidget *w, gchar ** filename )
{
    gchar *s;
    s = gtk_file_selection_get_filename(GTK_FILE_SELECTION(w->parent->parent->parent));
  	*filename = g_strdup (s);
    gtk_grab_remove(w->parent->parent->parent);
    gtk_widget_destroy(w->parent->parent->parent);
    gtk_main_quit();
}

void file_sel(gchar *title,gchar *start, gchar ** filename)
{
    GtkWidget *file_sel;
    file_sel = gtk_file_selection_new(title);
    gtk_file_selection_set_filename (GTK_FILE_SELECTION(file_sel),start);
    gtk_signal_connect (GTK_OBJECT(GTK_FILE_SELECTION(file_sel)->ok_button),"clicked", (GtkSignalFunc) file_sel_ok, filename);
    gtk_signal_connect (GTK_OBJECT(GTK_FILE_SELECTION(file_sel)->cancel_button),"clicked", (GtkSignalFunc) file_sel_cancel,filename);
    gtk_window_set_position (GTK_WINDOW (file_sel), GTK_WIN_POS_CENTER);
	gtk_widget_show(file_sel);
	gtk_window_set_transient_for (GTK_WINDOW (file_sel),GTK_WINDOW (app.main_window));
	gtk_grab_add(file_sel);
}


