/* Linux Commander
 * Copyright (C) 2000 Per Holmng.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "linuxcmd.h"

CopyToDialog copydlg;

void cb_copy_dlg_ok(GtkWidget *wid, gchar ** str)
{
	gchar *s;

	s = gtk_entry_get_text(GTK_ENTRY(copydlg.entry_dst));
	
	if (strlen (s) == 0)
    {
      	statusbar_print("What are you trying to do?");
      	return;
    }

  	*str = g_strdup (s);
	
	gtk_grab_remove(copydlg.win);
	gtk_widget_destroy(copydlg.win);
	gtk_main_quit();
}

void cb_copy_dlg_cancel(GtkWidget *wid, gchar ** str)
{
	*str = NULL;
	gtk_grab_remove(copydlg.win);
	gtk_widget_destroy(copydlg.win);
	gtk_main_quit();

}
void cb_entrysrc_keypress(GtkWidget *widget, GdkEventKey *event)
{
	if (event->keyval != GDK_Right || event->keyval != GDK_Left)
	{
		gtk_signal_emit_stop_by_name(GTK_OBJECT(widget), "key_press_event");
		return;
	}
}

void create_copy_dialog(const gchar *title,const gchar *txt1, const gchar *txt2, gchar **str )
{
	GtkWidget *label;
	GtkWidget *vbox;
	
	gint policy[3] = { 1,1,1 };
	copydlg.win = create_window(g_strdup(title),470,130,policy);
	gtk_container_set_border_width(GTK_CONTAINER(copydlg.win),5);
	copydlg.vbox = gtk_vbox_new(FALSE,5);
	gtk_container_add(GTK_CONTAINER(copydlg.win),copydlg.vbox);
	gtk_widget_show(copydlg.vbox);

	copydlg.frame = gtk_frame_new(NULL);
	gtk_container_set_border_width(GTK_CONTAINER(copydlg.frame),5);
	gtk_box_pack_start(GTK_BOX(copydlg.vbox),copydlg.frame,0,0,5);
	gtk_widget_show(copydlg.frame);

	vbox = gtk_vbox_new(FALSE,0);
	gtk_container_set_border_width(GTK_CONTAINER(vbox),5);
	gtk_container_add(GTK_CONTAINER(copydlg.frame),vbox);
	gtk_widget_show(vbox);
	
	copydlg.hbox = gtk_hbox_new(FALSE,5);
	gtk_box_pack_start(GTK_BOX(vbox),copydlg.hbox,0,0,0);
	gtk_widget_show(copydlg.hbox);
	
	label = gtk_label_new("Source: ");
	gtk_label_set_justify(GTK_LABEL(label),GTK_JUSTIFY_LEFT);
	gtk_widget_set_usize(GTK_WIDGET(label),75,10);
	gtk_box_pack_start(GTK_BOX(copydlg.hbox),label,0,0,0);
	gtk_widget_show(label);

	copydlg.entry_src = create_entry(g_strdup(txt1),0,NULL,NULL);
	gtk_signal_connect(GTK_OBJECT(copydlg.entry_src),"key-press-event",cb_entrysrc_keypress,NULL);
	gtk_box_pack_start(GTK_BOX(copydlg.hbox),copydlg.entry_src,1,1,0);
	
	copydlg.hbox = gtk_hbox_new(FALSE,5);
	gtk_box_pack_start(GTK_BOX(vbox),copydlg.hbox,0,0,0);
	gtk_widget_show(copydlg.hbox);
	
	label = gtk_label_new("Destination: ");
	gtk_widget_set_usize(GTK_WIDGET(label),75,10);
	gtk_box_pack_start(GTK_BOX(copydlg.hbox),label,0,0,0);
	gtk_widget_show(label);

	copydlg.entry_dst = create_entry(g_strdup(txt2),0,cb_copy_dlg_ok,str);
	gtk_box_pack_start(GTK_BOX(copydlg.hbox),copydlg.entry_dst,1,1,0);

	copydlg.hbox = gtk_hbox_new(FALSE,5);
	gtk_box_pack_start(GTK_BOX(copydlg.vbox),copydlg.hbox,0,0,0);
	gtk_widget_show(copydlg.hbox);

	copydlg.btn_ok = create_button("OK",cb_copy_dlg_ok,str);
	gtk_box_pack_start(GTK_BOX(copydlg.hbox),copydlg.btn_ok,1,1,0);
	gtk_widget_grab_default(GTK_WIDGET(copydlg.btn_ok));
	
	copydlg.btn_cancel = create_button("Cancel",cb_copy_dlg_cancel,str);
	gtk_box_pack_start(GTK_BOX(copydlg.hbox),copydlg.btn_cancel,1,1,0);

	gtk_window_set_position (GTK_WINDOW (copydlg.win), GTK_WIN_POS_CENTER);
	gtk_widget_show(copydlg.win);
	gtk_grab_add(copydlg.win);
	gtk_window_set_transient_for (GTK_WINDOW (copydlg.win),GTK_WINDOW (app.main_window));
	gtk_widget_grab_focus(copydlg.entry_dst);
	gtk_main();
}
