/* Linux Commander
 * Copyright (C) 2000 Per Holmng.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "linuxcmd.h"

gboolean gotorow = FALSE;
gint row = 1;

void cb_clist_grab_focus( GtkWidget *widget, FileList *list )
{
	gint i;
	GtkStyle *style;
	GtkStyle *style2;
	GdkColor COLOR1;
	GdkColor COLOR2;
	style = gtk_style_new ();
	style2 = gtk_style_new ();
	gdk_color_parse ("dark gray", &COLOR1);
	gdk_color_parse ("light gray", &COLOR2);
	style->bg[GTK_STATE_NORMAL] = COLOR1;
	style2->bg[GTK_STATE_NORMAL] = COLOR2;
	
	focused = list;
	notfocused = list->other;
	
	for (i = 0; i < 5; i++)
		gtk_widget_set_style (GTK_CLIST (list->clist)->column[i].button,style);

	for (i = 0; i < 5; i++)
		gtk_widget_set_style (GTK_CLIST	(list->other->clist)->column[i].button,style2);
	chdir(focused->workingdir);
    focused->has_focus = TRUE;
    notfocused->has_focus = TRUE;
}


void cb_clist_keypress(GtkWidget *widget, GdkEventKey *event, FileList *list)
{
	struct stat tmp;
	gchar *parent;
    gchar *buf;
    gchar *dir;
    
	if (event->state & GDK_CONTROL_MASK)
	{
		switch (event->keyval)
		{
            case 'h':
                if (config.show_hidden_files == TRUE)
                    config.show_hidden_files = FALSE;
                else
                    config.show_hidden_files = TRUE;            
                refresh_filelist(list,TRUE);
                refresh_filelist(list->other,TRUE);
                return;
                break;
			case 'r':
				refresh_filelist(list,TRUE);
                return;
				break;
            case GDK_Right:
                gtk_signal_emit_stop_by_name(GTK_OBJECT(list->clist), "key_press_event");
                if (app.left.has_focus)
                {
                    stat(focused->selectedfile,&tmp);
                    if (S_ISDIR(tmp.st_mode))
                        update_filelist(focused->selectedfile,notfocused);
                    else
                        update_filelist(focused->workingdir,notfocused);
                }
                break;
            case GDK_Left:
                gtk_signal_emit_stop_by_name(GTK_OBJECT(list->clist), "key_press_event");
                if (app.right.has_focus)
                {
                    stat(focused->selectedfile,&tmp);
                    if (S_ISDIR(tmp.st_mode))
                        update_filelist(focused->selectedfile,notfocused);
                    else
                        update_filelist(focused->workingdir,notfocused);
                }
                break;
		}
	}
	else
	switch (event->keyval)
	{
		case GDK_Right:
			if (config.lynxlike_motion)
			{
                struct stat tmp;

				stat(focused->selectedfile,&tmp);
				if (S_ISDIR (tmp.st_mode))
				{
					handle_file(focused->selectedfile,list);
				}
				return;
			}
			break;
		case GDK_Left:
			if (config.lynxlike_motion)
			{
				gint row;
				gint a;
				gchar *buf;
				gchar *bla;

				bla = focused->workingdir;
				
				parent = malloc(strlen(list->workingdir)+5);
				sprintf(parent,"%s/..",list->workingdir);
				handle_file(parent,list);
				
				for (a = 0; a < GTK_CLIST(list->clist)->rows; a++)
				{
					gtk_clist_get_text(GTK_CLIST(list->clist),a,5,&buf);	
					if (strcmp(buf,bla) == 0)
						break;
				}
                
                if (a < GTK_CLIST(focused->clist)->rows)
                {
    				gtk_clist_select_row(GTK_CLIST(list->clist),a,0);
                    GTK_CLIST(list->clist)->focus_row = a;
                    gtk_clist_sort(GTK_CLIST(list->clist));
                    gtk_clist_moveto(GTK_CLIST(list->clist),a,0,0.5,0.5);
                }
			}
			break;
		case ':':
			/*gtk_widget_grab_focus(GTK_WIDGET(GTK_COMBO(app.cmdline)->entry));*/
			break;
        case NumKeyMinus:
            cb_pattern_unselect();
            break;
        case '-':
            cb_pattern_unselect();
            break;
        case NumKeyPlus:
            cb_pattern_select();
			break;
		case '+':
			cb_pattern_select();
			break;
        case GDK_Insert:
            if (list->selectedrow != 0)
            {
                gtk_clist_get_text(GTK_CLIST(list->clist),list->selectedrow,6,&buf);
                if (strcmp(buf,"TRUE") == 0)
                {
                    gtk_clist_set_text(GTK_CLIST(list->clist),list->selectedrow,6,"FALSE");
                    gtk_clist_set_foreground(GTK_CLIST(list->clist),list->selectedrow,&color_reg);
                }
                else
                {
                    gtk_clist_set_text(GTK_CLIST(list->clist),list->selectedrow,6,"TRUE");
                    gtk_clist_set_foreground(GTK_CLIST(list->clist),list->selectedrow,&color_tag);
                }
            }
            gtk_clist_select_row(GTK_CLIST(list->clist),list->selectedrow+1,0);
            GTK_CLIST(list->clist)->focus_row = list->selectedrow;
            gtk_clist_sort(GTK_CLIST(list->clist));
            gtk_clist_moveto(GTK_CLIST(list->clist),list->selectedrow,0,0.5,0.5);
            break;
        case GDK_space:
            stat(focused->selectedfile,&tmp);
            if (S_ISDIR (tmp.st_mode) && strcmp(list->selectedfile,"/dev") != 0)
            {
                cb_dir_recurse_count_size(list);
            }
            gtk_clist_get_text(GTK_CLIST(list->clist),list->selectedrow,6,&buf);
            if (strcmp(buf,"TRUE") == 0)
            {
                gtk_clist_set_text(GTK_CLIST(list->clist),list->selectedrow,6,"FALSE");
                gtk_clist_set_foreground(GTK_CLIST(list->clist),list->selectedrow,&color_reg);
            }
            else
            {
                gtk_clist_set_text(GTK_CLIST(list->clist),list->selectedrow,6,"TRUE");
                gtk_clist_set_foreground(GTK_CLIST(list->clist),list->selectedrow,&color_tag);
            }
            break;

		case GDK_Return:
			handle_file(list->selectedfile,list);
			break;
		case GDK_Delete:
			cb_file_delete();
			break;
		case GDK_Home:
            gtk_clist_select_row(GTK_CLIST(list->clist),0,0);
            GTK_CLIST(list->clist)->focus_row = 0;
            gtk_clist_sort(GTK_CLIST(list->clist));
			gtk_clist_moveto(GTK_CLIST(list->clist),0,0,0.5,0.5);
			break;
		case GDK_End:
            gtk_clist_select_row(GTK_CLIST(list->clist),GTK_CLIST(list->clist)->rows-1,0);
            GTK_CLIST(list->clist)->focus_row = GTK_CLIST(list->clist)->rows-1;
            gtk_clist_sort(GTK_CLIST(list->clist));
			gtk_clist_moveto(GTK_CLIST(list->clist),GTK_CLIST(list->clist)->rows-1,0,0.5,0.5);
			break;
		case '/':
			update_filelist("/",list);
		case GDK_Tab:
			gtk_signal_emit_stop_by_name(GTK_OBJECT(list->clist), "key_press_event");
			gtk_widget_grab_focus(GTK_WIDGET(notfocused->clist));
            update_statusbar(focused);
			return;
			break;
    }
    update_statusbar(list);
}

void update_statusbar(FileList *list)
{
    statusbar_print(" %d / %d files, %s bytes",cb_clist_count_selection(list),GTK_CLIST (list->clist)->rows-1,
                    cb_clist_count_filesize(list));
}

void cb_cmbdir_activate( GtkWidget *widget, FileList *list )
{
	gchar *path;
	path = gtk_entry_get_text(GTK_ENTRY(widget));
	update_filelist(path,list);
}

void cb_window_resize(GtkWidget *widget,GtkAllocation *allocation,gpointer user_data)
{
	gtk_paned_set_position(GTK_PANED(user_data),(allocation->width/2-2.5));
	gtk_clist_set_column_width(GTK_CLIST(app.left.clist),0,allocation->width/2-135);
	gtk_clist_set_column_width(GTK_CLIST(app.right.clist),0,allocation->width/2-135);
}

void cb_clist_select_all()
{
    gint a;

    for (a = 1; a < GTK_CLIST (focused->clist)->rows; a++)
    {
        gtk_clist_set_text(GTK_CLIST(focused->clist),a,6,"TRUE");
        gtk_clist_set_foreground(GTK_CLIST(focused->clist),a,&color_tag);
    }
    update_statusbar(focused);
}

void cb_clist_select_none()
{
	gint a;

    for (a = 1; a < GTK_CLIST (focused->clist)->rows; a++)
    {
        gtk_clist_set_text(GTK_CLIST(focused->clist),a,6,"FALSE");
        gtk_clist_set_foreground(GTK_CLIST(focused->clist),a,&color_reg);
    }
    update_statusbar(focused);
}

void cb_clist_select_invert()
{
    gint a;
    gchar *buf;
    
    for (a = 1; a < GTK_CLIST (focused->clist)->rows; a++)
    {
        gtk_clist_get_text(GTK_CLIST(focused->clist),a,6,&buf);
        if (strcmp(buf,"TRUE") == 0)
        {
            gtk_clist_set_text(GTK_CLIST(focused->clist),a,6,"FALSE");
            gtk_clist_set_foreground(GTK_CLIST(focused->clist),a,&color_reg);
        }
        else
        {
            gtk_clist_set_text(GTK_CLIST(focused->clist),a,6,"TRUE");
            gtk_clist_set_foreground(GTK_CLIST(focused->clist),a,&color_tag);
        }
    }
    update_statusbar(focused);
}

void cb_clist_select_row(GtkWidget *clist, gint row,gint column,
						GdkEvent *event, FileList *list)
{
	gchar 		*txtbuf;
	
    update_statusbar(list);
	gtk_clist_get_text(GTK_CLIST(clist),row,5,&txtbuf);
	list->selectedfile = txtbuf;
	list->selectedrow = row;
	if (event)
    {
		if(event->type == GDK_2BUTTON_PRESS)
		{
			handle_file(list->selectedfile,list);		
		}
	}
}

void cb_clist_button_press(GtkWidget *clist, GdkEventButton *event,FileList *list)
{
	gint x, y, row, column;
	GdkModifierType state;
	gint a,sum;

    gdk_window_get_pointer(event->window, &x, &y, &state);
    gtk_clist_get_selection_info(GTK_CLIST(clist), x, y, &row,&column);

    gtk_widget_grab_focus(GTK_WIDGET(clist));
    
    gtk_clist_select_row(GTK_CLIST(list->clist),row,0);
    GTK_CLIST(list->clist)->focus_row = row;
    gtk_clist_sort(GTK_CLIST(list->clist));

	if (event->button == config.select_button)
	{
        gchar *buf;
        gtk_clist_get_text(GTK_CLIST(clist),row,6,&buf);
        if (strcmp(buf,"TRUE") == 0)
        {
            gtk_clist_set_text(GTK_CLIST(clist),row,6,"FALSE");
            gtk_clist_set_foreground(GTK_CLIST(clist),row,&color_reg);
        }
        else
        {
            gtk_clist_set_text(GTK_CLIST(clist),row,6,"TRUE");
            gtk_clist_set_foreground(GTK_CLIST(clist),row,&color_tag);
        }
	}
	else if (event->button == config.popup_button) 
	{
		gtk_clist_select_row(GTK_CLIST(clist),row,column);
		app.popup_menu = create_popup (app.main_window);
		gtk_menu_popup (GTK_MENU (app.popup_menu), NULL, NULL, NULL, NULL,
   	    	            event->button, event->time);
	}
    update_statusbar(list);
}

/* File operations callbacks */
void cb_file_move()
{
	struct stat stat_d;
	GList *tmp;
	gint count = 0;
	gchar *dst_str,*src_str;
	gchar *dst;
	
	/* 1. Kolla antalet fokuserade filer */
	tmp = get_selection(focused,5);
	for (; tmp != NULL; tmp = tmp->next) 
	{
		count++;
	}
	/* Inga filer fokuserade. Avsluta */
	if (count < 1)
	{
		statusbar_print(" No files to copy!");
		return;
	}
	/* Om bara en fil stt destinationen till hela filnamnet */
	if (count == 1)
	{
		dst_str = malloc(strlen(notfocused->workingdir) + strlen(focused->selectedfile)+3);
		sprintf(dst_str,"%s/%s",notfocused->workingdir,strrchr(focused->selectedfile,'/')+1);
		src_str = malloc(strlen(focused->selectedfile)+1);
		sprintf(src_str,"%s",focused->selectedfile);
	}
	/* Annars stt destinationen till katalogen */
	else
	{
		dst_str = malloc(strlen(notfocused->workingdir));
		sprintf(dst_str,"%s",notfocused->workingdir);
		src_str = malloc(strlen(focused->workingdir)+15);
		sprintf(src_str,"%d files in %s",count,focused->workingdir);
	}
	/* Ta reda p destinationen */
	create_copy_dialog("Copy",src_str,dst_str,&dst);
	/* Ingen destination. Avsluta */
	if (dst == NULL)
		return;
	/* Kolla att destination r en katalog. Existerar den inte, frga om anv. vill skapa */
	if (count > 1)
	{
		if ((stat(dst,&stat_d)) == -1)
		{
			gint *button;
			GString *mkdir_msg = g_string_new("");

			g_string_sprintf(mkdir_msg," The directory %s does not exist. Create it?",dst);
			create_dialog("MkDir","",mkdir_msg->str,90,&button);
			gtk_main();
			if ((int)button == 0)
				make_dir(dst);
 			else
				return;
		}
		else if (!S_ISDIR(stat_d.st_mode))
		{
			statusbar_print(" Destination is not a directory!");
			return;
		}
	}
	filemove(focused,dst);

}
/* Copy callback. filecopy() & dircopy() in copy.c */
void cb_file_copy()
{
	struct stat stat_d;
	GList *tmp;
	gint count = 0;
	gchar *dst_str,*src_str;
	gchar *dst;

    printf("%s\n",focused->selectedfile);

	/* 1. Kolla antalet fokuserade filer */
	tmp = get_selection(focused,5);
	for (; tmp != NULL; tmp = tmp->next) 
	{
		count++;
	}
	/* Inga filer fokuserade. Avsluta */
	if (count < 1)
	{
		statusbar_print(" No files to copy!");
		return;
	}
	/* Om bara en fil stt destinationen till hela filnamnet */
	if (count == 1)
	{
		dst_str = malloc(strlen(notfocused->workingdir) + strlen(focused->selectedfile)+3);
		sprintf(dst_str,"%s/%s",notfocused->workingdir,strrchr(focused->selectedfile,'/')+1);
		src_str = malloc(strlen(focused->selectedfile)+1);
		sprintf(src_str,"%s",focused->selectedfile);
	}
	/* Annars stt destinationen till katalogen */
	else
	{
		dst_str = malloc(strlen(notfocused->workingdir));
		sprintf(dst_str,"%s",notfocused->workingdir);
		src_str = malloc(strlen(focused->workingdir)+15);
		sprintf(src_str,"%d files in %s",count,focused->workingdir);
	}
	/* Ta reda p destinationen */
	create_copy_dialog("Copy",src_str,dst_str,&dst);
    free(src_str);
    free(dst_str);
	/* Ingen destination. Avsluta */
	if (dst == NULL)
    {
        statusbar_print(" Copy aborted by user");
		return;
    }
	/* Kolla att destination r en katalog. Existerar den inte, frga om anv. vill skapa */
    if (count > 1)
	{
		if ((stat(dst,&stat_d)) == -1)
		{
			gint *button;
			GString *mkdir_msg = g_string_new("");

			g_string_sprintf(mkdir_msg," The directory %s does not exist. Create it?",dst);
			create_dialog("MkDir","",mkdir_msg->str,90,&button);
			gtk_main();
			if ((int)button == 0)
				make_dir(dst);
 			else
				return;
		}
		else if (!S_ISDIR(stat_d.st_mode))
		{
			statusbar_print(" Destination is not a directory!");
			return;
		}
	}
	file_copy(focused,dst);
}

void cb_file_rename()
{
	gchar *oldname=0;
	gchar *newname=0;
	
	if (strcmp(strrchr(focused->selectedfile,'/')+1,"..") != 0)
	{
		oldname = focused->selectedfile;
		create_dialog_with_entry("Rename","New name: ",oldname,&newname);
		gtk_main ();
		if (newname != NULL)
		{
			filemove(focused,newname);
			if (strcmp(focused->workingdir,notfocused->workingdir) == 0)
				refresh_filelist(notfocused,FALSE);
			refresh_filelist(focused,FALSE);			
		}
	}
}

void cb_file_delete()
{
	gint count = 0;
	gint *button;
	gint height = 90;
	GList *tmp;
	GString *msg = g_string_new("Are you sure you want to remove the file(s):\n");
	struct stat stattmp;
	
	tmp = get_selection(focused,5);
	for (; tmp != NULL; tmp = tmp->next) 
	{
		g_string_sprintfa(msg,"%s\n",(char *)tmp->data);
		if (height < 250)
			height += 15;
		count++;
	}
	if (count < 1)
	{
		statusbar_print(" No files to delete!");
		return;
	}
	tmp = get_selection(focused,5);
	
	if (config.confirmation_del_normal == TRUE)
	{
		create_dialog("Delete","",msg->str,height,&button);
		gtk_main();
	}
	else
		(int)button = 1;

	if ((int)button == 1)
	{
		for (; tmp != NULL; tmp = tmp->next) 
		{
			stat(tmp->data,&stattmp);
			if (S_ISDIR (stattmp.st_mode))
				del_dir(tmp->data);
			else
				del_file(tmp->data);
		}
		
		refresh_filelist(focused,FALSE);
		if (strcmp(focused->workingdir,notfocused->workingdir) == 0)
			refresh_filelist(notfocused,FALSE);
	}
	return;
}

void cb_file_mkdir()
{
	gchar *dir_name;
	
	create_dialog_with_entry("Create Directory","Name: ",focused->workingdir,&dir_name);
	gtk_main ();
	if (dir_name != NULL)
	{
		make_dir(dir_name);
		refresh_filelist(focused,0);
	}
}

void cb_pattern_unselect()
{
    gchar *pattern;
	gchar *tmpbuf;
	gchar *strip;
	gint a;

	create_dialog_with_entry("Pattern unselect","Pattern: ","*",&pattern);
	gtk_main ();

	if (pattern != NULL)
	{
		for (a = 1; a < GTK_CLIST(focused->clist)->rows; a++) 
		{
			gtk_clist_unselect_row(GTK_CLIST(focused->clist),a,0);
			gtk_clist_get_text(GTK_CLIST(focused->clist),a,5,&tmpbuf);
			strip = (char *)strrchr(tmpbuf,'/');
			strip++;
			if (fnmatch(pattern,strip,0) == 0)
            {
				gtk_clist_set_text(GTK_CLIST(focused->clist),a,6,"FALSE");
                gtk_clist_set_foreground(GTK_CLIST(focused->clist),a,&color_reg);
            }
		}	
	}
}

void cb_pattern_select()
{
	gchar *pattern;
	gchar *tmpbuf;
	gchar *strip;
	gint a;

	create_dialog_with_entry("Pattern select","Pattern: ","*",&pattern);
	gtk_main ();

	if (pattern != NULL)
	{
		for (a = 1; a < GTK_CLIST(focused->clist)->rows; a++) 
		{
			gtk_clist_unselect_row(GTK_CLIST(focused->clist),a,0);
			gtk_clist_get_text(GTK_CLIST(focused->clist),a,5,&tmpbuf);
			strip = (char *)strrchr(tmpbuf,'/');
			strip++;
			if (fnmatch(pattern,strip,0) == 0)
            {
				gtk_clist_set_text(GTK_CLIST(focused->clist),a,6,"TRUE");
                gtk_clist_set_foreground(GTK_CLIST(focused->clist),a,&color_tag);
            }
		}	
	}
}

void cb_preferences()
{
	create_prefs_window("Preferences",600,500,0);
	gtk_main();
}

void cb_file_execute()
{
	if (strcmp(strrchr(focused->selectedfile,'/')+1,"..") != 0)
	{
		execute_program(focused->selectedfile);
	}
}

void cb_file_execute_in_xterm()
{
	if (strcmp(strrchr(focused->selectedfile,'/')+1,"..") != 0)
	{
		xterm_exec(focused->selectedfile);
	}
}

void cb_open_dir_in_xterm()
{
	gchar *cmd = malloc(strlen(focused->selectedfile)+5);
	xterm_exec(cmd);
}

void cb_fileinfo()
{
	if (strcmp(strrchr(focused->selectedfile,'/')+1,"..") != 0)
	{
		create_fileinfo_window(focused->selectedfile,200,200);
		gtk_main();
	}
}

void cb_popup_execute_program(gchar *string)
{
	gchar *prg;
	prg = parse_program_string(string);
	if (prg)
		execute_program(prg);
}

void cb_openwith()
{
	gchar *str;
	gchar *cmd;
	
	if (strcmp(strrchr(focused->selectedfile,'/')+1,"..") != 0)
	{
		create_dialog_with_entry("Open with...","Program: ","",&str);
		gtk_main ();
		if (str)
		{
			cmd = malloc(strlen(str)+strlen(focused->selectedfile)+5);
			sprintf(cmd,"%s %s",str,focused->selectedfile);
			execute_program(cmd);
			free(cmd);
		}
	}
}

void cb_execute_with_arg(GtkWidget *widget, gchar *program)
{
	gchar *cmd;
	
	cmd = malloc(strlen(program)+strlen(focused->selectedfile)+5);
	sprintf(cmd,"%s %s",program,focused->selectedfile);
	printf("%s\n",cmd);
	execute_program(cmd);
	free(cmd);
}

void cb_perms()
{
	if (strcmp(strrchr(focused->selectedfile,'/')+1,"..") != 0)
	{
		create_perms_window(focused->selectedfile,270,245);
		gtk_main();
	}
}


void cb_create_tar_archive()
{
	GList *tmp = NULL;
	gchar *strip;
	gchar *wrkdir;
	gchar *name;
	GString *cmd = g_string_new("");
	
	create_dialog_with_entry("Create archive","Filename: ","",&name);
	gtk_main ();
	
	if (name)
	{
		g_string_sprintf(cmd,"%s -e sh -c \"tar c ",config.xterm);
		tmp = get_selection(focused,5);
		for (; tmp != NULL; tmp = tmp->next) 
		{
			strip = strrchr(tmp->data,'/');
			g_string_sprintfa(cmd,"\"%s\" ",strip+1);
		}
		g_string_sprintfa(cmd,"| gzip > %s\"",name);
		execute_program(cmd->str);
		printf("%s\n",cmd->str);
	}
}

void cb_associate()
{
	create_prefs_window("Preferences",600,500,1);
	gtk_main();
}

void cb_fileview()
{
    create_fileview_window(focused->selectedfile);
}

void cb_mount()
{
    create_mount_window();
    gtk_main();
}

void cb_search()
{
    create_search_window();
}

void cb_browsedir(GtkWidget *wid, GtkWidget *entry)
{
    gchar *dir;

    create_dirbrowse_window(&dir);
    gtk_main();
    if (dir)
        gtk_entry_set_text(GTK_ENTRY(entry),dir);       
}


