/* Linux Commander
 * Copyright (C) 2000 Per Holmng.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "linuxcmd.h"

GtkWidget *ass_window;
GtkWidget *ass_new_window;
GtkWidget *entry1,*entry2,*entry3;
GtkWidget *chkdefault;
GdkColor def_color;

gint ass_selectedrow = -1;
void write_associations(GtkWidget *clist);
void associations_dialog_close();
void create_ass_new_dialog(gchar *title,gchar *txt1,gchar *txt2,gchar *txt3,GtkWidget *clist, gint def);
void cb_ass_new_ok(GtkWidget *wid, GtkWidget *clist);
void cb_ass_new_cancel(GtkWidget *wid, GtkWidget *clist);

void cb_ass_new_ok(GtkWidget *wid, GtkWidget *clist)
{
	gchar *buf[3];
	gint def;
    gint row;
	gint rownr; 
	
	def = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(chkdefault));
	buf[0] = gtk_entry_get_text(GTK_ENTRY(entry1));
	buf[1] = gtk_entry_get_text(GTK_ENTRY(entry2));
	buf[2] = gtk_entry_get_text(GTK_ENTRY(entry3));
	
	if (ass_selectedrow == -1)
	{
		rownr = gtk_clist_append(GTK_CLIST(clist),buf);
		if (def)
		{
			gtk_clist_set_foreground(GTK_CLIST(clist),rownr,&def_color);
			gtk_clist_set_row_data(GTK_CLIST(clist),rownr,(gpointer)1);
		}
		else
			gtk_clist_set_row_data(GTK_CLIST(clist),rownr,0);
	}
	else
	{
        row = ass_selectedrow;
		gtk_clist_remove(GTK_CLIST(clist),ass_selectedrow);
		gtk_clist_insert(GTK_CLIST(clist),row,buf);
		if (def)
		{
			gtk_clist_set_foreground(GTK_CLIST(clist),row,&def_color);
			gtk_clist_set_row_data(GTK_CLIST(clist),row,(gpointer)1);
		}
		else
			gtk_clist_set_row_data(GTK_CLIST(clist),row,0);
	}
	gtk_grab_remove(ass_new_window);
	gtk_widget_destroy(ass_new_window);
	gtk_main_quit();
	write_associations(clist);
}

void cb_ass_new_cancel(GtkWidget *wid, GtkWidget *clist)
{
	gtk_grab_remove(ass_new_window);
	gtk_widget_destroy(ass_new_window);
	gtk_main_quit();
}

void create_ass_new_dialog(gchar *title,gchar *txt1,gchar *txt2,gchar *txt3,GtkWidget *clist,gint def)
{
	GtkWidget *label;
	GtkWidget *button;
	GtkWidget *frame;
	GtkWidget *table;
	GtkWidget *hbox,*vbox;
	
	gint policy[3] = {0,1,1};

	ass_new_window = create_window(title,400,188,policy);
	gtk_signal_connect(GTK_OBJECT(ass_new_window),"delete-event",
						GTK_SIGNAL_FUNC(cb_delete_event),NULL);
	gtk_container_set_border_width(GTK_CONTAINER(ass_new_window),5);
	
	vbox = gtk_vbox_new(FALSE,5);
	gtk_container_add(GTK_CONTAINER(ass_new_window),vbox);
	gtk_widget_show(vbox);

	frame = gtk_frame_new(0);
	gtk_box_pack_start(GTK_BOX(vbox),frame,0,0,5);
	gtk_widget_show(frame);
	
	table = gtk_table_new(4,3,FALSE);
	gtk_container_set_border_width(GTK_CONTAINER(table),5);
	gtk_container_add(GTK_CONTAINER(frame),table);
	gtk_widget_show(table);
	
	label = gtk_label_new("Extension(s): ");
	gtk_label_set_justify(GTK_LABEL(label),GTK_JUSTIFY_RIGHT);
	gtk_table_attach(GTK_TABLE(table),label,0,1,0,1,GTK_FILL,0,5,0);
	gtk_widget_show(label);

	entry1 = create_entry(txt1,0,NULL,NULL);
	gtk_table_attach(GTK_TABLE(table),entry1,1,2,0,1,GTK_FILL | GTK_EXPAND,0,5,0);

	label = gtk_label_new("Name: ");
	gtk_label_set_justify(GTK_LABEL(label),GTK_JUSTIFY_LEFT);
	gtk_table_attach(GTK_TABLE(table),label,0,1,1,2,GTK_FILL,1,5,0);
	gtk_widget_show(label);

	entry2 = create_entry(txt2,0,NULL,NULL);
	gtk_table_attach(GTK_TABLE(table),entry2,1,2,1,2,GTK_FILL | GTK_EXPAND,0,5,0);

	label = gtk_label_new("Command: ");
	gtk_label_set_justify(GTK_LABEL(label),GTK_JUSTIFY_LEFT);
	gtk_table_attach(GTK_TABLE(table),label,0,1,2,3,GTK_FILL,1,5,0);
	gtk_widget_show(label);

	entry3 = create_entry(txt3,0,NULL,NULL);
	gtk_table_attach(GTK_TABLE(table),entry3,1,2,2,3,GTK_FILL | GTK_EXPAND,0,5,0);
	
    button = create_button("Insert",create_functions_dialog,entry3);
    gtk_table_attach(GTK_TABLE(table),button,2,3,2,3,GTK_FILL,1,5,0);
    
	chkdefault = gtk_check_button_new_with_label("Default doubleclick action?");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chkdefault),def);
	gtk_table_attach(GTK_TABLE(table),chkdefault,0,2,3,4,GTK_FILL | GTK_EXPAND,0,5,5);
	gtk_widget_show(chkdefault);
		
	hbox = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,0,0,0);
	gtk_widget_show(hbox);

	button = create_button("OK",cb_ass_new_ok,clist);
	gtk_box_pack_end(GTK_BOX(hbox),button,1,1,5);
	gtk_widget_grab_default(GTK_WIDGET(button));
	button = create_button("Cancel",cb_ass_new_cancel,clist);
	gtk_box_pack_end(GTK_BOX(hbox),button,1,1,5);
	
	gtk_window_set_position (GTK_WINDOW (ass_new_window), GTK_WIN_POS_CENTER);
	gtk_widget_show(ass_new_window);
	gtk_window_set_transient_for (GTK_WINDOW (ass_new_window),GTK_WINDOW (app.main_window));
	gtk_grab_add(ass_new_window);
    gtk_widget_grab_focus(entry1);
	
}

void ass_new(GtkWidget *wid, GtkWidget *clist)
{
    gint tmp_row;
    tmp_row = ass_selectedrow;
    ass_selectedrow = -1;
	create_ass_new_dialog("New assocation","","","",clist,0);
	gtk_main();
    ass_selectedrow = tmp_row;
}

void ass_edit(GtkWidget *wid, GtkWidget *clist)
{
	gchar *buf1,*buf2,*buf3;
	gint def;

	def = (gint)gtk_clist_get_row_data(GTK_CLIST(clist),ass_selectedrow);	
	
	gtk_clist_get_text(GTK_CLIST(clist),ass_selectedrow,0,&buf1);
	gtk_clist_get_text(GTK_CLIST(clist),ass_selectedrow,1,&buf2);
	gtk_clist_get_text(GTK_CLIST(clist),ass_selectedrow,2,&buf3);

	create_ass_new_dialog("Edit association",buf1,buf2,buf3,clist,def);
	gtk_main();
}

void ass_remove(GtkWidget *wid, GtkWidget *clist)
{
	gtk_clist_remove(GTK_CLIST(clist),ass_selectedrow);
	write_associations(clist);
}

void cb_ass_clist_select_row(GtkWidget *clist, gint row,gint column,GdkEvent *event, FileList *list)
{
	ass_selectedrow = row;
	if (event)
	{
		if (event->type == GDK_2BUTTON_PRESS)
		{
			ass_edit(NULL,clist);
		}
	}
}

void cb_ass_clist_unselect_row(GtkWidget *clist, gint row,gint column,GdkEvent *event, FileList *list)
{
	ass_selectedrow = -1;
	if (event)
	{
		if (event->type == GDK_2BUTTON_PRESS)
		{
			ass_edit(NULL,clist);
		}
	}
}


void write_associations(GtkWidget *clist)
{
	gint a;
	FILE *fp;
	gchar *ext,*name,*command;
	gint def;
	
	if ((fp = fopen(get_file_extensions_filename(),"w")))
	{
		for (a = 0; a < GTK_CLIST(clist)->rows; a++)
		{
			gtk_clist_get_text(GTK_CLIST(clist),a,0,&ext);
			gtk_clist_get_text(GTK_CLIST(clist),a,1,&name);
			gtk_clist_get_text(GTK_CLIST(clist),a,2,&command);
			def = (gint)gtk_clist_get_row_data(GTK_CLIST(clist),a);
			if (def)
				fprintf(fp,"%s;%s;%s;default\n",ext,name,command);
			else
				fprintf(fp,"%s;%s;%s\n",ext,name,command);
		}
		gtk_clist_set_column_width(GTK_CLIST(clist),0,gtk_clist_optimal_column_width(GTK_CLIST(clist),0));
		gtk_clist_set_column_width(GTK_CLIST(clist),1,gtk_clist_optimal_column_width(GTK_CLIST(clist),1));
		fclose(fp);
	}
}

void get_associations(GtkWidget *clist)
{
	FILE *fp;
	gchar buf[256];
	gchar *row[3];
	gchar *strip,*def;
	gint rownr = 0;
	gint tmp;
    
    gdk_color_parse("blue",&def_color);
	gtk_clist_freeze(GTK_CLIST(clist));
	if ((fp = fopen(get_file_extensions_filename(),"r")))
	{
		while (fgets(buf,256,fp))
		{
			if ((strip = strchr(buf,'\n')))
				*strip = 0;
			row[0] = strtok(buf,";");
			row[1] = strtok(NULL,";");
			row[2] = strtok(NULL,";");
			def = strtok(NULL,";");
			gtk_clist_append(GTK_CLIST(clist),row);
			if (def)
			{
				gtk_clist_set_row_data(GTK_CLIST(clist),rownr,(gpointer)1);
				gtk_clist_set_foreground(GTK_CLIST(clist),rownr,&def_color);
			} 
			else gtk_clist_set_row_data(GTK_CLIST(clist),rownr,0);
			rownr++;
		}
        tmp = gtk_clist_optimal_column_width(GTK_CLIST(clist),0);
        if (tmp > 70)
            gtk_clist_set_column_width(GTK_CLIST(clist),0,tmp);
        else
            gtk_clist_set_column_width(GTK_CLIST(clist),0,70);

        tmp = gtk_clist_optimal_column_width(GTK_CLIST(clist),1);
        if (tmp > 50)
            gtk_clist_set_column_width(GTK_CLIST(clist),1,tmp);
        else
            gtk_clist_set_column_width(GTK_CLIST(clist),1,50);
		fclose(fp);
	}
	gtk_clist_thaw(GTK_CLIST(clist));
}
