/* Linux Commander
 * Copyright (C) 2000 Per Holmng.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "linuxcmd.h"
#include "logo.xpm"

GtkWidget *about_window;

void close_about_window()
{
	gtk_grab_remove(about_window);
	gtk_widget_destroy(about_window);
	gtk_main_quit();
}

void create_about_window()
{
	GdkPixmap	*pixmap;
	GdkBitmap	*mask;
	GtkWidget 	*wid;
	GtkWidget 	*vbox;
	GtkWidget	*scrollwin;
	GtkWidget	*label;
	GtkWidget	*frame;
	GtkWidget	*button;
	
	gint policy[3] = {0,0,0};
	about_window = create_window("About Linux Commander",295,290,policy);
	gtk_signal_connect(GTK_OBJECT(about_window),"delete-event",
						GTK_SIGNAL_FUNC(close_about_window),NULL);
	gtk_container_set_border_width(GTK_CONTAINER(about_window),5);

	vbox = gtk_vbox_new(FALSE,5);
	gtk_container_add(GTK_CONTAINER(about_window),vbox);
	gtk_widget_show(vbox);
	
	frame = gtk_frame_new(NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_OUT);
	gtk_widget_show(frame);

	pixmap = gdk_pixmap_create_from_xpm_d(GTK_WIDGET(app.main_window)->window, &mask,NULL,logo_xpm);
	wid = gtk_pixmap_new(pixmap, mask);
	gtk_widget_show(wid);
	gtk_container_add(GTK_CONTAINER(frame),wid);
	gtk_box_pack_start(GTK_BOX(vbox),frame,0,0,0);
	
	scrollwin = gtk_scrolled_window_new(NULL,NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrollwin),GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start(GTK_BOX(vbox),scrollwin,1,1,5);
	gtk_widget_show(scrollwin);
	
	label = gtk_label_new("Linux Commander "VERSION"\nAuthor: Per Holmng <skeleton@algonet.se>\nWith help from: Olle Hallns <olle@xmms.org>\n\nhttp://www.algonet.se/~skeleton/linuxcmd/");
	gtk_label_set_justify(GTK_LABEL(label),GTK_JUSTIFY_CENTER);
	gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrollwin),label);
	gtk_widget_show(label);

	button = create_button("Close",close_about_window,NULL);
	gtk_box_pack_start(GTK_BOX(vbox),button,0,0,5);
	gtk_widget_grab_default(GTK_WIDGET(button));
	
	gtk_window_set_position (GTK_WINDOW (about_window), GTK_WIN_POS_CENTER);
	gtk_widget_show(about_window);
	gtk_grab_add(about_window);
	gtk_window_set_transient_for (GTK_WINDOW (about_window),GTK_WINDOW (app.main_window));
	gtk_main();
	
}
