#!/bin/sh

name="linux_logo"
title="linux_logo"
package="linux_logo"
version="4.02"
build="1"
noarch="n"
build_info="Standard build."

info="Shows a logo with some system info."
desc="linux_logo displays beautiful logos of Linux, its distributions
and other Unices. What is more, it can show some informations
on system, such as CPU, RAM and so on."
category="toys/console"
environment="console/text"
contact="$name@packages.packware.one.pl"
vendor="The Packware Project"
vendor_id="pw"

requires=""
obsoletes=""
conflicts=""

docs_source="ANNOUNCE.logo,BUGS,CHANGES,COPYING,LINUX_LOGO.FAQ,README,README.CUSTOM_LOGOS,TODO,USAGE"
docs_cwd=""

strip_bin="y"
reset_own="y"
reset_dir="y"
reset_fil="y"
delete_cat="y"

. /usr/src/tgz/lib/builder.defs

add_source http://www.intersec.pl/~swiergot/$name-$version.tar.gz

apply_patch linux_logo-share-locale.pw.patch
apply_patch linux_logo-am_cflags.pw.patch

cat << EOF > $src1/logo_config
./logos/banner.logo
./logos/classic.logo
./logos/classic-no_periods.logo
./logos/distributions/gnu-linux.logo
./logos/distributions/slackware.logo
EOF

make_option DESTDIR=/usr
make_option INSTALL_DOCPATH=/usr/doc/$name-$version
# The default is /usr/lib/locale - wrong!
make_option INSTALLDIR=/usr/share/locale

install_option DESTDIR=$pkg_main/usr
install_option INSTALL_DOCPATH=$pkg_main/usr/doc/$name-$version
install_option INSTALLDIR=$pkg_main/usr/share/locale

parent_package="$package"
write_info main

cd $src1

do_make

mkdir -p $pkg_main/usr/bin
mkdir -p $pkg_main/usr/man/man1
mkdir -p $pkg_main/usr/share/locale

do_install

make_docs

make_package main

clean_up

# $Log: linux_logo.builder,v $
# Revision 1.3  2002/12/25 23:47:39  swiergot
# - Build 1.
#
# Revision 1.2  2002/12/25 23:32:45  swiergot
# - Touched to force building.
#
# Revision 1.1  2002/12/25 23:17:20  swiergot
# - Initial release.
# - Version 4.02.
#
