#!/bin/sh

name="fetchmail"
title="fetchmail"
package="fetchmail"
version="6.2.1"
build="1"
noarch="n"
build_info="Standard build."

info="A powerful mail retrival utility."
desc="Fetchmail is a free, full-featured, robust, well-documented
remote-mail retrieval and forwarding utility intended to be
used over on-demand TCP/IP links (such as SLIP or PPP
connections). It supports every remote-mail protocol now in
use on the Internet: POP2, POP3, RPOP, APOP, KPOP, all flavors
of IMAP, and ESMTP ETRN. It can even support IPv6 and IPSEC."
category="net/client/mail"
environment="console/text"
contact="$name@packages.packware.one.pl"
vendor="The Packware Project"
vendor_id="pw"

requires=""
obsoletes=""
conflicts=""

docs_source="ABOUT-NLS,COPYING,FEATURES,INSTALL,MANIFEST,NEWS,NOTES,README*,TODO,*.html,contrib"
docs_cwd=""

strip_bin="y"
reset_own="y"
reset_dir="y"
reset_fil="y"
delete_cat="y"

. /usr/src/tgz/lib/builder.defs

add_source http://www.catb.org/~esr/fetchmail/$name-$version.tar.gz

configure_option --prefix=/usr
configure_option --enable-nls
configure_option --with-ssl

install_option DESTDIR=$pkg_main

parent_package="$package"
write_info main

cd $src1

# Cite from Patrick: "this is the sloppiest source tarball ever" :-)

chown -R `id -u`.`id -g` .
find . -perm 664 -exec chmod 644 {} \;
find . -perm 600 -exec chmod 644 {} \;
find . -perm 444 -exec chmod 644 {} \;
find . -perm 400 -exec chmod 644 {} \;
find . -perm 440 -exec chmod 644 {} \;
find . -perm 777 -exec chmod 755 {} \;
find . -perm 775 -exec chmod 755 {} \;
find . -perm 511 -exec chmod 755 {} \;
find . -perm 711 -exec chmod 755 {} \;
find . -perm 555 -exec chmod 755 {} \;

do_configure
do_make
do_install

make_docs

rm -rf $pkg_main/usr/doc/$name-$version/contrib/RCS

make_package main

clean_up

# $Log: fetchmail.builder,v $
# Revision 1.6  2003/01/23 18:15:50  swiergot
# - Build 1.
#
# Revision 1.5  2003/01/23 17:29:34  swiergot
# - Version 6.2.1.
# - Changed source URL to the new server.
#
# Revision 1.4  2002/12/26 15:14:10  swiergot
# - Build 1.
#
# Revision 1.3  2002/12/26 14:39:59  swiergot
# - Removed unneeded FAQ from docs_source.
#
# Revision 1.2  2002/12/26 13:57:12  swiergot
# - Removed empty fetchmail.lsm from docs_source.
#
# Revision 1.1  2002/12/26 13:36:29  swiergot
# - Initial release.
# - Version 6.2.0.
#
