/* The contents of this file are subject to the Netscape Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/NPL/
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code is Mozilla Communicator client code, released
 * March 31, 1998.
 *
 * The Initial Developer of the Original Code is Netscape
 * Communications Corporation. Portions created by Netscape are
 * Copyright (C) 1998-1999 Netscape Communications Corporation. All
 * Rights Reserved.
 *
 */ 

var actvInst = null;
var prefService = null;
var webmailCookie, webmailUserName, webmailUserMailCode;
var smtpService = null;

actvInst = Components.classes["@mozilla.org/profile/activation;1"].createInstance();
actvInst = actvInst.QueryInterface(Components.interfaces.nsIActivation);

prefs = Components.classes['@mozilla.org/preferences;1'];
prefs = prefs.getService();
prefs = prefs.QueryInterface(Components.interfaces.nsIPref);
    

// Get the cookie netcenter sent down to us.
// Setup a partial account on primary email address, if rdf file is found 
// Setup a partial account for the new netcenter member
function SetupPartialAccounts()
{
    var cookieID   = "NS_C5A_REG";
    var emailID    = "NS_C5A_E";
    var memberID   = "NS_C5A_PN";
    var delimiter  = "[-]";
    var begin, end;
    var primaryEmail, netcenterEmail;
    var webmailDomain = "@netscape.net";
    var aFranklinUser = false;

    var actvCookie = actvInst.getCookie();
    if (!actvCookie) return null;  

    begin = actvCookie.indexOf(cookieID);
    if (begin == -1) return null;

    end   = actvCookie.indexOf(";", begin);
    if (end == -1) 
        end = actvCookie.length;

    actvCookie = actvCookie.substring(begin, end);

    actvCookie = unescape(actvCookie);
    dump("Act Cookie : " + actvCookie + "\n");

    // Check if there is a webmail cookie
    // If there is one get user details
    GetWebmailUserDetails();

    // Extract primary email address..
    begin = actvCookie.indexOf(emailID);
    if (begin != -1) {
        end   = actvCookie.indexOf(delimiter, begin);
        primaryEmail = actvCookie.substring(begin+emailID.length+1, end);
 
        // We need partial account setup only for non webmail accounts here..
        // Webmail accounts will have to go through webmail cookie check
        if (primaryEmail.indexOf(webmailDomain) == -1)
        {
            // Create partial account for primary email
            CreateIncompleteMailAccount(primaryEmail);
        }
    }

    // Extract member name and make a webmail address..
    begin = actvCookie.indexOf(memberID);
    if (begin != -1) {
        end   = actvCookie.indexOf(delimiter, begin);
        // Get the netcenter member name
        var memberName = actvCookie.substring(begin+memberID.length+1, end);

        // Create a netcenterEmail address using member name and webmail domain
        netcenterEmail  = memberName;
        netcenterEmail += webmailDomain;

        // If there is a webmail cookie, we need to check it
        // All migrated users will already have a cookie had they accessed webmail lately
        // All new users will have a new webmail cookie set by Franklin as they are registered
        if (webmailCookie) {
            // If the user is an existing member/new member, to be a Franklin user, 
            // user name should match the name in the webmail cookie and the 
            // user's mail code set in the webmail cookie should be '0'. 
            // If the mailcode is '1', he/she is USA.net user and no partial 
            // accounts for such cases yet.
           if (webmailUserName == memberName) {
               if (webmailUserMailCode ==  0)
                   aFranklinUser = true;
           }
        }

        // Set a generic pref that other modules can use to enable services.
        // Create a partial Franklin account.
        if (aFranklinUser) {
            if (!prefs)
                return null;
            
            prefs.SetBoolPref("mail.is_a_franklin_user", true);
            // Create partial accounts for only Franklin users
            CreateIncompleteMailAccount(netcenterEmail);
        }
    }
}

// Get the use email address and create an incomplete mail account
// Use ispUtils to grab the right values from corresponsing isp's rdf file 
function CreateIncompleteMailAccount(emailAddress)
{
    dump("Create (Incomplete) Account : Begin" + "\n");

    if (!emailAddress) return null;
 
    dump("Email address : " + emailAddress + "\n");
    var emailData = emailAddress.split('@');
  
    if (emailData.length != 2) {
        dump("bad e-mail address!\n");
        return null;
    }

    // Get ISP information from rdf file based on email address..
    var ispInfo; 
    if (getIspDefaultsForEmail)
        ispInfo = getIspDefaultsForEmail(emailAddress);

    try {
        var am = Components.classes["@mozilla.org/messenger/account-manager;1"].getService();
        am = am.QueryInterface(Components.interfaces.nsIMsgAccountManager);
    
        var srcServer = ispInfo.incomingServer;
    
        // Creating incoming server
        dump("Creating Incoming Server..\n");
        var destServer = am.createIncomingServer(emailData[0],
                                                 srcServer.hostName,
                                                 srcServer.type);
    
        // Copy all attributes of incoming server from ispInfo (srcServer)
        // into the server we created (destServer)
        if (copyObjectToInterface)
            copyObjectToInterface(destServer, srcServer);

        // see if there are any protocol-specific attributes
        // if so, we use the type to get the IID, QueryInterface
        // as appropriate, then copy the data over
        dump("srcServer.ServerType-" + srcServer.type + " = " +
             srcServer["ServerType-" + srcServer.type] + "\n");
        if (srcServer["ServerType-" + srcServer.type]) {
            // handle server-specific stuff
            var IID;
            if (getInterfaceForType)
                IID = getInterfaceForType(srcServer.type);
            if (IID) {
                destProtocolServer = destServer.QueryInterface(IID);
                srcProtocolServer = srcServer["ServerType-" + srcServer.type];

                dump("Copying over " + srcServer.type + "-specific data\n");
                copyObjectToInterface(destProtocolServer, srcProtocolServer);
            }
        }
        destServer.valid = true;

        // Get an identity from ispInfo 
        var srcIdentity = ispInfo.identity;

        dump("Creating Identity..\n");
        var destIdentity   = am.createIdentity();

        // Copy all attributes of source identity got from ispInfo 
        // into the identity we created
        copyObjectToInterface(destIdentity, srcIdentity);

        destIdentity.email = emailAddress;
        destIdentity.valid = false;
        
        // Get SMTP Service
        if (!smtpService) {
            smtpService = Components.classes["@mozilla.org/messengercompose/smtp;1"].getService(Components.interfaces.nsISmtpService);
        }          

        var smtpServer;
           
        /**
         * Create a new smtp server if needed. If smtpCreateNewServer pref
         * is set then createSmtpServer routine() will create one. Otherwise,
         * default server is returned which is also set to create a new smtp server
         * (via GetDefaultServer()) if no default server is found.
         */
        if (ispInfo.smtpCreateNewServer)
            smtpServer = smtpService.createSmtpServer(); 
        else 
            smtpServer = smtpService.defaultServer;
        // Copy smtp server information 
        copyObjectToInterface(smtpServer, ispInfo.smtp);

        // some identities have 'preferred' 
        if (ispInfo.smtpUsePreferredServer && destIdentity)
            destIdentity.smtpServerKey = smtpServer.key;
        
        if (!smtpServer.username &&
          ispInfo.smtpRequiresUsername) {
          smtpServer.username = emailData[0];
        }

        var account = am.createAccount();
        account.incomingServer = destServer;
        account.addIdentity(destIdentity);

        // hack hack - save the prefs file NOW in case we crash
        try {
          var prefs = Components.classes["@mozilla.org/preferences;1"].getService(Components.interfaces.nsIPref);
          prefs.savePrefFile(null);
        } catch (ex) {
        }
    }
    catch (ex)
    {
        dump("failed to create a partial mail account using AccountManager\n");
    }
    dump("Create (Incomplete) Account : End" + "\n");
}

// This function reads the webmail cookie from users cookie file and 
// and extracts information about the username and the mailsystem code.
//
// Sample webmail cookie : NS_WM=foo:0:200007180230[-]WM_LOGGED
// In the above cookie, NS_WM is the cookie name, foo is the username, 
// 0 is the mailcode and we don't care about the other details.
//
// If the mailcode is 0 - User is a Franklin user
// If the mailcode is 1 - User is a USA.net user
function GetWebmailUserDetails()
{
    var webmailCookieID = "NS_WM";
    var begin, end;

    // Get webmail cookie.
    webmailCookie   = actvInst.getWebMailCookie();

    begin = webmailCookie.indexOf(webmailCookieID);
    if (begin == -1) {
        webmailCookie = null;
        return null;
    }

    // Increase begin index to ignore the cookie ID name and '=' part 
    begin += webmailCookieID.length + 1;

    end = webmailCookie.indexOf(";", begin);
    if (end == -1) 
        end = webmailCookie.length;

    webmailCookie = webmailCookie.substring(begin, end);

    if (webmailCookie) {
        dump("webmail cookie : " + webmailCookie + "\n");

        var webmailData     = webmailCookie.split(':');

        // Get webmail user name and mailcode
        webmailUserName     = webmailData[0];
        webmailUserMailCode = webmailData[1];
    }
    else {
        webmailCookie = null;
    }
}

